/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.MiscUtil;

public class RecipeListHelper
implements IRecipeList {
    private List<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();

    public RecipeListHelper(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public RecipeListHelper(List<IRecipeInfo> recipeList) {
        this.setRecipeList(recipeList);
    }

    @Override
    public List<IRecipeInfo> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Override
    public void setRecipeList(List<IRecipeInfo> recipeList) {
        this.recipeList.clear();
        this.recipeList.addAll(recipeList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.recipeList.clear();
        if (nbt != null) {
            NBTTagList tagList = nbt.func_150295_c("Recipes", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                IRecipeInfo recipe = MiscUtil.readRecipeFromNBT(tag);
                if (recipe == null) continue;
                this.recipeList.add(recipe);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (IRecipeInfo recipe : this.recipeList) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), recipe);
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Recipes", (NBTBase)tagList);
        return nbt;
    }
}

