/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.energy.EnergyStorageCustom;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.extendedcrafting.compat.gregtech.IGTCapHolder;
import com.blakebr0.extendedcrafting.compat.gregtech.IGTEnergyContainer;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.lib.EmptyContainer;
import com.blakebr0.extendedcrafting.lib.FakeRecipeHandler;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import com.blakebr0.extendedcrafting.tile.TileAdvancedCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileBasicCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileEliteCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileEnderCrafter;
import com.blakebr0.extendedcrafting.tile.TileInventoryBase;
import com.blakebr0.extendedcrafting.tile.TileUltimateCraftingTable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Optional.Interface(modid="gregtech", iface="com.blakebr0.extendedcrafting.compat.gregtech.IGTEnergyContainer")
public class TileAutomationInterface
extends TileInventoryBase
implements ITickable,
ISidedInventory,
IGTEnergyContainer,
IGTCapHolder {
    private final ItemStackHandler inventory = new StackHandler();
    private final ItemStackHandler recipe = new FakeRecipeHandler();
    private final EnergyStorageCustom energy = new EnergyStorageCustom(ModConfig.confInterfaceRFCapacity);
    private int oldEnergy;
    private ItemStack result = ItemStack.field_190927_a;
    private boolean hasRecipe = false;
    private int recipeSize;
    private int autoInsert = -1;
    private int autoExtract = -1;
    private boolean autoEject = false;
    private boolean smartInsert = true;
    private int ticks = 0;

    public TileAutomationInterface() {
        super("interface");
    }

    public void func_73660_a() {
        boolean mark = false;
        ++this.ticks;
        if (!this.func_145831_w().field_72995_K) {
            boolean scheduledTransfer;
            ItemStack input = this.getInventory().getStackInSlot(0);
            ItemStack output = this.getInventory().getStackInSlot(1);
            boolean hasTable = this.hasTable();
            if (!input.func_190926_b() && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate) {
                this.handleInput(input, hasTable && this.hasRecipe());
            }
            if (hasTable && this.hasRecipe() && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate && this.ticks % 10 == 0) {
                this.handleOutput(output);
            }
            boolean bl = scheduledTransfer = this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate && this.ticks % 4 == 0;
            if (scheduledTransfer) {
                mark = this.transfer(input, this.getInserterFace(), true);
                mark |= this.transfer(output, this.getExtractorFace(), false);
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            mark = true;
        }
        if (this.ticks > 100) {
            this.ticks = 0;
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    private boolean transfer(ItemStack stack, @Nullable EnumFacing side, boolean insert) {
        if (side == null || !insert && stack.func_190926_b()) {
            return insert;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile == null) {
            return insert;
        }
        IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        if (cap == null) {
            return insert;
        }
        for (int slot = 0; slot < cap.getSlots(); ++slot) {
            ItemStack newStack;
            ItemStack toInsert;
            ItemStack s = cap.getStackInSlot(slot);
            if (insert) {
                if (s.func_190926_b() || !this.checkStackSmartly(toInsert = StackHelper.withSize((ItemStack)s.func_77946_l(), (int)1, (boolean)false)) || !stack.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)stack, (ItemStack)toInsert) || (newStack = cap.extractItem(slot, 1, false)).func_190926_b()) continue;
                this.getInventory().insertItem(0, toInsert, false);
            } else {
                toInsert = StackHelper.withSize((ItemStack)stack.func_77946_l(), (int)1, (boolean)false);
                newStack = cap.insertItem(slot, toInsert, false);
                if (!newStack.func_190926_b()) continue;
                stack.func_190918_g(1);
            }
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
            return true;
        }
        return false;
    }

    private void handleInput(ItemStack input, boolean canInsert) {
        ItemStack output = this.getInventory().getStackInSlot(1);
        ItemStack toInsert = StackHelper.withSize((ItemStack)input.func_77946_l(), (int)1, (boolean)false);
        IExtendedTable table = null;
        IInventory matrix = null;
        int slotToPut = -1;
        if (canInsert) {
            table = this.getTable();
            if (table == null) {
                return;
            }
            ItemStackHandler recipe = this.getRecipe();
            matrix = (IInventory)table;
            ItemStack stackToPut = ItemStack.field_190927_a;
            for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                ItemStack slot = matrix.func_70301_a(i);
                ItemStack recipeStack = recipe.getStackInSlot(i);
                if (!slot.func_190926_b() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.func_190926_b() && slot.func_190916_E() >= slot.func_77976_d()) continue;
                if (slot.func_190926_b()) {
                    slotToPut = i;
                    break;
                }
                if (!stackToPut.func_190926_b() && slot.func_190916_E() >= stackToPut.func_190916_E()) continue;
                slotToPut = i;
                stackToPut = slot.func_77946_l();
            }
        }
        if (matrix != null && slotToPut > -1) {
            this.insertItem(matrix, slotToPut, toInsert);
            input.func_190918_g(1);
            if (this.isCraftingTable()) {
                table.setResult(TableRecipeManager.getInstance().findMatchingRecipe(new TableCrafting(new EmptyContainer(), table), this.func_145831_w()));
            }
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        } else if (this.getAutoEject() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)toInsert))) {
            this.getInventory().insertItem(1, toInsert, false);
            input.func_190918_g(1);
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        }
    }

    public void handleOutput(ItemStack output) {
        IExtendedTable table = this.getTable();
        if (table == null) {
            return;
        }
        ItemStack result = table.getResult();
        IInventory matrix = (IInventory)table;
        if (!result.func_190926_b() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)result)) && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate) {
            ItemStack toInsert = result.func_77946_l();
            if (this.isEnderCrafter()) {
                table.setResult(ItemStack.field_190927_a);
            } else {
                for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                    ItemStack slotStack = matrix.func_70301_a(i);
                    ItemStack recipeStack = this.getRecipe().getStackInSlot(i);
                    if (recipeStack.func_190926_b() || !slotStack.func_190926_b() && StackHelper.areStacksEqual((ItemStack)recipeStack, (ItemStack)slotStack)) continue;
                    return;
                }
                NonNullList<ItemStack> remaining = this.getRemainingItems(matrix);
                for (int i = 0; i < remaining.size(); ++i) {
                    ItemStack itemstack = matrix.func_70301_a(i);
                    ItemStack itemstack1 = (ItemStack)remaining.get(i);
                    if (!itemstack.func_190926_b()) {
                        matrix.func_70298_a(i, 1);
                        itemstack = matrix.func_70301_a(i);
                    }
                    if (itemstack1.func_190926_b()) continue;
                    if (itemstack.func_190926_b()) {
                        matrix.func_70299_a(i, itemstack1);
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)itemstack1) || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)itemstack1)) continue;
                    itemstack1.func_190917_f(itemstack.func_190916_E());
                    matrix.func_70299_a(i, itemstack1);
                }
                table.setResult(TableRecipeManager.getInstance().findMatchingRecipe(new TableCrafting(new EmptyContainer(), table), this.func_145831_w()));
            }
            this.getInventory().insertItem(1, toInsert, false);
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_179237_a(this.inventory.serializeNBT());
        tag.func_179237_a(this.recipe.serializeNBT());
        tag.func_74768_a("RecipeSize", this.recipeSize);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        tag.func_74782_a("Result", (NBTBase)this.result.serializeNBT());
        tag.func_74757_a("HasRecipe", this.hasRecipe);
        tag.func_74768_a("AutoInsert", this.autoInsert);
        tag.func_74768_a("AutoExtract", this.autoExtract);
        tag.func_74757_a("AutoEject", this.autoEject);
        tag.func_74757_a("SmartInsert", this.smartInsert);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag);
        this.recipe.deserializeNBT(tag);
        this.recipeSize = tag.func_74762_e("RecipeSize");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
        this.result = new ItemStack(tag.func_74775_l("Result"));
        this.hasRecipe = tag.func_74767_n("HasRecipe");
        this.autoInsert = tag.func_74762_e("AutoInsert");
        this.autoExtract = tag.func_74762_e("AutoExtract");
        this.autoEject = tag.func_74767_n("AutoEject");
        this.smartInsert = tag.func_74767_n("SmartInsert");
        if (this.recipeSize == 0) {
            this.recipeSize = (int)Math.sqrt(this.recipe.getSlots());
        }
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return index >= 0 && index < this.inventory.getSlots() && !this.inventory.getStackInSlot(index).func_190926_b() && count > 0 ? this.inventory.getStackInSlot(index).func_77979_a(count) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index >= 0 && index < this.inventory.getSlots()) {
            ItemStack stack = this.inventory.getStackInSlot(index);
            this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = this.inventory.getStackInSlot(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.setStackInSlot(index, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        Object cap;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, side));
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        if (ModConfig.confInterfaceAcceptGTEU && (cap = this.getGTCapability(capability)) != null) {
            return (T)cap;
        }
        return (T)super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getRecipe() {
        return this.recipe;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public EnergyStorageCustom getEnergy() {
        return this.energy;
    }

    @Nullable
    public IExtendedTable getTable() {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        return tile instanceof IExtendedTable ? (IExtendedTable)tile : null;
    }

    public boolean hasTable() {
        IExtendedTable table = this.getTable();
        return table != null && (!this.hasRecipe() || table.getLineSize() == this.recipeSize);
    }

    public boolean isEnderCrafter() {
        return this.getTable() instanceof TileEnderCrafter;
    }

    public boolean isCraftingTable() {
        IExtendedTable table = this.getTable();
        return table instanceof TileBasicCraftingTable || table instanceof TileAdvancedCraftingTable || table instanceof TileEliteCraftingTable || table instanceof TileUltimateCraftingTable;
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setHasRecipe(boolean hasRecipe) {
        this.hasRecipe = hasRecipe;
    }

    public void saveRecipe() {
        ItemStackHandler recipe = this.getRecipe();
        IExtendedTable table = this.getTable();
        if (table == null) {
            return;
        }
        NonNullList<ItemStack> matrix = table.getMatrix();
        recipe.setSize(matrix.size());
        for (int i = 0; i < matrix.size(); ++i) {
            recipe.setStackInSlot(i, ((ItemStack)matrix.get(i)).func_77946_l());
        }
        if (this.isEnderCrafter()) {
            TableCrafting crafting = new TableCrafting(new EmptyContainer(), table);
            this.result = EnderCrafterRecipeManager.getInstance().findMatchingRecipe(crafting, this.func_145831_w()).func_77572_b(crafting);
        } else {
            ItemStack result = table.getResult();
            if (result != null) {
                this.result = result;
            }
        }
        this.setHasRecipe(true);
        this.recipeSize = table.getLineSize();
        this.func_70296_d();
    }

    public void clearRecipe() {
        ItemStackHandler recipe = this.getRecipe();
        recipe.setSize(1);
        this.result = ItemStack.field_190927_a;
        this.setHasRecipe(false);
        this.func_70296_d();
    }

    @Nullable
    public EnumFacing getInserterFace() {
        return this.autoInsert > -1 && this.autoInsert < EnumFacing.values().length ? EnumFacing.values()[this.autoInsert] : null;
    }

    @Nullable
    public EnumFacing getExtractorFace() {
        return this.autoExtract > -1 && this.autoExtract < EnumFacing.values().length ? EnumFacing.values()[this.autoExtract] : null;
    }

    public void switchInserter() {
        if (this.autoInsert >= EnumFacing.values().length - 1) {
            this.autoInsert = -1;
        } else {
            ++this.autoInsert;
            if (this.autoInsert == EnumFacing.DOWN.func_176745_a()) {
                ++this.autoInsert;
            }
        }
        this.func_70296_d();
    }

    public void switchExtractor() {
        if (this.autoExtract >= EnumFacing.values().length - 1) {
            this.autoExtract = -1;
        } else {
            ++this.autoExtract;
            if (this.autoExtract == EnumFacing.DOWN.func_176745_a()) {
                ++this.autoExtract;
            }
        }
        this.func_70296_d();
    }

    public void disableInserter() {
        if (this.autoInsert != -1) {
            this.autoInsert = -1;
            this.func_70296_d();
        }
    }

    public void disableExtractor() {
        if (this.autoExtract != -1) {
            this.autoExtract = -1;
            this.func_70296_d();
        }
    }

    public boolean checkStackSmartly(ItemStack stack) {
        if (!this.getSmartInsert()) {
            return true;
        }
        if (!this.hasTable()) {
            return false;
        }
        if (!this.hasRecipe()) {
            return false;
        }
        IExtendedTable table = this.getTable();
        if (table == null) {
            return false;
        }
        NonNullList<ItemStack> matrix = table.getMatrix();
        for (int i = 0; i < matrix.size(); ++i) {
            ItemStack slotStack = (ItemStack)matrix.get(i);
            ItemStack recipeStack = this.getRecipe().getStackInSlot(i);
            if (!StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)recipeStack) || !slotStack.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)stack, (ItemStack)slotStack)) continue;
            return true;
        }
        return false;
    }

    public boolean getAutoEject() {
        return this.autoEject;
    }

    public void toggleAutoEject() {
        this.autoEject = !this.autoEject;
        this.func_70296_d();
    }

    public boolean getSmartInsert() {
        return this.smartInsert;
    }

    public void toggleSmartInsert() {
        this.smartInsert = !this.smartInsert;
        this.func_70296_d();
    }

    private void insertItem(IInventory matrix, int slot, ItemStack stack) {
        ItemStack slotStack = matrix.func_70301_a(slot);
        if (slotStack.func_190926_b()) {
            matrix.func_70299_a(slot, stack);
        } else if (StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)slotStack) && slotStack.func_190916_E() < slotStack.func_77976_d()) {
            ItemStack newStack = slotStack.func_77946_l();
            int newSize = Math.min(slotStack.func_190916_E() + stack.func_190916_E(), slotStack.func_77976_d());
            newStack.func_190920_e(newSize);
            matrix.func_70299_a(slot, newStack);
        }
    }

    private NonNullList<ItemStack> getRemainingItems(IInventory matrix) {
        NonNullList ret = NonNullList.func_191197_a((int)matrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)matrix.func_70301_a(i)));
        }
        return ret;
    }

    class StackHandler
    extends ItemStackHandler {
        StackHandler() {
            super(2);
        }

        public void onContentsChanged(int slot) {
            TileAutomationInterface.this.func_70296_d();
        }
    }
}

