/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.items;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.items.IHasItemMeshDefinition;
import com.teamacronymcoders.base.items.itemblocks.ItemBlockGeneric;
import com.teamacronymcoders.base.subblocksystem.blocks.BlockSubBlockHolder;
import com.teamacronymcoders.base.subblocksystem.blocks.ISubBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockSubBlockHolder
extends ItemBlockGeneric<BlockSubBlockHolder>
implements IHasItemColor,
IHasItemMeshDefinition {
    public ItemBlockSubBlockHolder(BlockSubBlockHolder block) {
        super(block);
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        return tintIndex == 0 ? ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(stack.func_77960_j()).getColor() : -1;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(stack.func_77960_j()).getLocalizedName();
    }

    @Nonnull
    public CreativeTabs[] getCreativeTabs() {
        ArrayList creativeTabsList = Lists.newArrayList();
        ((BlockSubBlockHolder)this.getActualBlock()).getSubBlocks().values().forEach(subBlock -> {
            if (subBlock.getCreativeTab() != null && !creativeTabsList.contains(subBlock.getCreativeTab())) {
                creativeTabsList.add(subBlock.getCreativeTab());
            }
        });
        return creativeTabsList.toArray(new CreativeTabs[0]);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        ItemStack itemstack = player.func_184586_b(hand);
        int i = this.func_77647_b(itemstack.func_77960_j());
        if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack) && ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(i).canPlaceBlockAt(world, pos) && world.func_190527_a(this.field_150939_a, pos, false, facing, null)) {
            IBlockState placementState = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, placementState)) {
                placementState = world.func_180495_p(pos);
                SoundType soundtype = placementState.func_177230_c().getSoundType(placementState, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public ResourceLocation getResourceLocation(ItemStack itemStack) {
        return ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(itemStack.func_77960_j()).getTextureLocation();
    }

    @Override
    public List<ResourceLocation> getAllVariants() {
        return ((BlockSubBlockHolder)this.getActualBlock()).getSubBlocks().values().stream().map(ISubBlock::getTextureLocation).collect(Collectors.toList());
    }
}

