/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import zone.rong.mixinbooter.IEarlyMixinLoader;
import zone.rong.mixinextras.injector.ModifyExpressionValueInjectionInfo;
import zone.rong.mixinextras.injector.ModifyReceiverInjectionInfo;
import zone.rong.mixinextras.injector.ModifyReturnValueInjectionInfo;
import zone.rong.mixinextras.injector.WrapWithConditionInjectionInfo;
import zone.rong.mixinextras.injector.wrapoperation.WrapOperationApplicatorExtension;
import zone.rong.mixinextras.injector.wrapoperation.WrapOperationInjectionInfo;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-2147483647)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");

    public static void initMixinExtra(boolean runtime) {
        InjectionInfo.register(ModifyExpressionValueInjectionInfo.class);
        InjectionInfo.register(ModifyReceiverInjectionInfo.class);
        InjectionInfo.register(ModifyReturnValueInjectionInfo.class);
        InjectionInfo.register(WrapWithConditionInjectionInfo.class);
        InjectionInfo.register(WrapOperationInjectionInfo.class);
        if (runtime) {
            MixinBooterPlugin.registerExtension(new WrapOperationApplicatorExtension());
        }
    }

    private static void registerExtension(IExtension extension) {
        IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        Extensions extensions = (Extensions)transformer.getExtensions();
        try {
            Field activeExtensionsField = Extensions.class.getDeclaredField("activeExtensions");
            activeExtensionsField.setAccessible(true);
            ArrayList<IExtension> activeExtensions = new ArrayList<IExtension>((List)activeExtensionsField.get(extensions));
            activeExtensions.add(extension);
            activeExtensionsField.set(extensions, Collections.unmodifiableList(activeExtensions));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(String.format("Failed to inject extension %s. Please inform Rongmario!", extension), e);
        }
    }

    public MixinBooterPlugin() {
        LOGGER.info("MixinBootstrap Initializing...");
        MixinBootstrap.init();
        MixinBooterPlugin.initMixinExtra(true);
        Mixins.addConfiguration("mixin.mixinbooter.init.json");
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.mixinbooter.MixinBooterPlugin$Container";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (coremodList instanceof List) {
            for (Object coremod : (List)coremodList) {
                try {
                    Field field = coremod.getClass().getField("coreModInstance");
                    field.setAccessible(true);
                    Object theMod = field.get(coremod);
                    if (!(theMod instanceof IEarlyMixinLoader)) continue;
                    IEarlyMixinLoader loader = (IEarlyMixinLoader)theMod;
                    for (String mixinConfig : loader.getMixinConfigs()) {
                        if (!loader.shouldMixinConfigQueue(mixinConfig)) continue;
                        LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                        Mixins.addConfiguration(mixinConfig);
                        loader.onMixinConfigQueued(mixinConfig);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        Launch.classLoader.addTransformerExclusion("scala.");
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            ModMetadata meta = this.getMetadata();
            meta.modId = "mixinbooter";
            meta.name = "MixinBooter";
            meta.description = "A Mixin library and loader.";
            meta.version = "7.1";
            meta.logoFile = "/icon.png";
            meta.authorList.add("Rongmario");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }
    }
}

