/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.metatileentity;

import gregicality.multiblocks.api.capability.IParallelHatch;
import gregicality.multiblocks.api.capability.IParallelMultiblock;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregicality.multiblocks.api.metatileentity.GCYMMultiblockAbility;
import gregicality.multiblocks.common.GCYMConfigHolder;
import gregtech.api.GTValues;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiMapMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class GCYMRecipeMapMultiblockController
extends MultiMapMultiblockController
implements IParallelMultiblock {
    public GCYMRecipeMapMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap) {
        this(metaTileEntityId, new RecipeMap[]{recipeMap});
    }

    public GCYMRecipeMapMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?>[] recipeMaps) {
        super(metaTileEntityId, recipeMaps);
        this.recipeMapWorkable = new GCYMMultiblockRecipeLogic((RecipeMapMultiblockController)this);
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        if (this.isParallel()) {
            tooltip.add(I18n.func_135052_a((String)"gcym.tooltip.parallel_enabled", (Object[])new Object[0]));
        }
        if (GCYMConfigHolder.globalMultiblocks.enableTieredCasings && this.isTiered()) {
            tooltip.add(I18n.func_135052_a((String)"gcym.tooltip.tiered_hatch_enabled", (Object[])new Object[0]));
        }
    }

    protected void addExtraDisplayInfo(List<ITextComponent> textList) {
        super.addExtraDisplayInfo(textList);
        List list = this.getAbilities(GCYMMultiblockAbility.TIERED_HATCH);
        if (GCYMConfigHolder.globalMultiblocks.enableTieredCasings && !list.isEmpty()) {
            long maxVoltage = Math.min(GTValues.V[((ITieredMetaTileEntity)list.get(0)).getTier()], Math.max(this.energyContainer.getInputVoltage(), this.energyContainer.getOutputVoltage()));
            String voltageName = GTValues.VNF[((ITieredMetaTileEntity)list.get(0)).getTier()];
            textList.add((ITextComponent)new TextComponentTranslation("gcym.multiblock.tiered_hatch.tooltip", new Object[]{maxVoltage, voltageName}));
        }
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public int getMaxParallel() {
        return this.getAbilities(GCYMMultiblockAbility.PARALLEL_HATCH).isEmpty() ? 1 : ((IParallelHatch)this.getAbilities(GCYMMultiblockAbility.PARALLEL_HATCH).get(0)).getCurrentParallel();
    }

    public boolean isTiered() {
        return GCYMConfigHolder.globalMultiblocks.enableTieredCasings;
    }

    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkEnergyIn, checkMaintenance, checkItemIn, checkItemOut, checkFluidIn, checkFluidOut, checkMuffler);
        if (this.isParallel()) {
            predicate = predicate.or(GCYMRecipeMapMultiblockController.abilities((MultiblockAbility[])new MultiblockAbility[]{GCYMMultiblockAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1).setPreviewCount(1));
        }
        return predicate;
    }

    @Nonnull
    public static TraceabilityPredicate tieredCasing() {
        return new TraceabilityPredicate(GCYMRecipeMapMultiblockController.abilities((MultiblockAbility[])new MultiblockAbility[]{GCYMMultiblockAbility.TIERED_HATCH}).setMinGlobalLimited(GCYMConfigHolder.globalMultiblocks.enableTieredCasings ? 1 : 0).setMaxGlobalLimited(1));
    }
}

