/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.unification.properties;

import com.google.common.collect.ImmutableList;
import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;

public class GCYMAutogeneratedPropertyAddition {
    public static void init() {
        for (Material material : GregTechAPI.MATERIAL_REGISTRY) {
            GCYMAutogeneratedPropertyAddition.addAlloyBlastProperty(material);
        }
    }

    public static void addAlloyBlastProperty(Material material) {
        ImmutableList components = material.getMaterialComponents();
        if (components.size() <= 1) {
            return;
        }
        if (material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION)) {
            return;
        }
        BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        if (blastProperty == null) {
            return;
        }
        if (!OrePrefix.ingotHot.doGenerateItem(material)) {
            return;
        }
        if (!material.hasProperty(PropertyKey.FLUID)) {
            return;
        }
        if (components.stream().filter(ms -> !ms.material.hasProperty(PropertyKey.DUST) && ms.material.hasProperty(PropertyKey.FLUID)).count() > 2L) {
            return;
        }
        material.setProperty(GCYMPropertyKey.ALLOY_BLAST, (IMaterialProperty)new AlloyBlastProperty(material.getBlastTemperature()));
    }
}

