/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.common.metatileentities.multiblock.standard;

import gregicality.multiblocks.api.metatileentity.GCYMMultiblockAbility;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;

public class MetaTileEntityLargeDistillery
extends GCYMRecipeMapMultiblockController {
    public MetaTileEntityLargeDistillery(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, new RecipeMap[]{RecipeMaps.DISTILLATION_RECIPES, RecipeMaps.DISTILLERY_RECIPES});
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityLargeDistillery(this.metaTileEntityId);
    }

    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return Vec3i::func_177956_o;
    }

    @Nonnull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casingPredicate = MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(40);
        TraceabilityPredicate maintenancePredicate = this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance ? MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH}).setMinGlobalLimited(1).setMaxGlobalLimited(1) : casingPredicate;
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.DOWN).aisle(new String[]{"#####", "#ZZZ#", "#ZCZ#", "#ZZZ#", "#####"}).aisle(new String[]{"##X##", "#XAX#", "XAPAX", "#XAX#", "##X##"}).setRepeatable(1, 12).aisle(new String[]{"#YSY#", "YAAAY", "YATAY", "YAAAY", "#YYY#"}).aisle(new String[]{"#YYY#", "YYYYY", "YYYYY", "YYYYY", "#YYY#"}).where('S', this.selfPredicate()).where('Y', casingPredicate.or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS})).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1)).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMinGlobalLimited(1)).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS})).or(MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{GCYMMultiblockAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1).setPreviewCount(1)).or(maintenancePredicate)).where('X', casingPredicate.or(MetaTileEntityLargeDistillery.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])((List)MultiblockAbility.REGISTRY.get(MultiblockAbility.EXPORT_FLUIDS)).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new))).setMinLayerLimited(1).setMaxLayerLimited(1))).where('Z', casingPredicate).where('P', MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{this.getCasingState2()})).where('C', MetaTileEntityLargeDistillery.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('T', MetaTileEntityLargeDistillery.tieredCasing().or(MetaTileEntityLargeDistillery.states((IBlockState[])new IBlockState[]{this.getCasingState2()}))).where('A', MetaTileEntityLargeDistillery.air()).where('#', MetaTileEntityLargeDistillery.any()).build();
    }

    private IBlockState getCasingState() {
        return GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState(BlockLargeMultiblockCasing.CasingType.WATERTIGHT_CASING);
    }

    private IBlockState getCasingState2() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GCYMTextures.WATERTIGHT_CASING;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        FluidStack stackInTank;
        super.addDisplayText(textList);
        if (this.isStructureFormed() && (stackInTank = this.importFluids.drain(Integer.MAX_VALUE, false)) != null && stackInTank.amount > 0) {
            TextComponentTranslation fluidName = new TextComponentTranslation(stackInTank.getFluid().getUnlocalizedName(stackInTank), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.distillation_tower.distilling_fluid", new Object[]{fluidName}));
        }
    }

    @Nonnull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return GCYMTextures.LARGE_DISTILLERY_OVERLAY;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean isTiered() {
        return false;
    }
}

