/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls;

import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.lwjgl.input.Mouse;

public class PanelButtonCustom
extends CanvasEmpty
implements IPanelButton {
    private final int buttonId;
    private boolean isActive = true;
    private Consumer<PanelButtonCustom> callback;
    private boolean isEnabled = true;
    private boolean pendingRelease;
    private final IGuiTexture[] texStates = new IGuiTexture[3];

    public PanelButtonCustom(IGuiRect transform, int buttonId) {
        super(transform);
        this.buttonId = buttonId;
        this.setTextures(PresetTexture.BTN_NORMAL_0.getTexture(), PresetTexture.BTN_NORMAL_1.getTexture(), PresetTexture.BTN_NORMAL_2.getTexture());
    }

    @Override
    public int getButtonID() {
        return this.buttonId;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean state) {
        this.isActive = state;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        IGuiTexture t;
        int curState;
        IGuiRect bounds = this.getTransform();
        int n = !this.isActive() ? 0 : (curState = bounds.contains(mx, my) ? 2 : 1);
        if (curState == 2 && this.pendingRelease && Mouse.isButtonDown((int)0)) {
            curState = 0;
        }
        if ((t = this.texStates[curState]) != null) {
            t.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
        }
        super.drawPanel(mx, my, partialTick);
    }

    @Override
    public void onButtonClick() {
        if (this.callback != null) {
            this.callback.accept(this);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        boolean used = super.onMouseClick(mx, my, click);
        if (used) {
            return true;
        }
        boolean contains = this.getTransform().contains(mx, my);
        this.pendingRelease = this.isActive() && click == 0 && contains;
        return (click == 0 || click == 1) && contains;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean clicked;
        boolean released = super.onMouseRelease(mx, my, click);
        if (released) {
            return true;
        }
        if (!this.pendingRelease) {
            return false;
        }
        this.pendingRelease = false;
        IGuiRect bounds = this.getTransform();
        boolean bl = clicked = this.isActive() && click == 0 && bounds.contains(mx, my) && !PEventBroadcaster.INSTANCE.postEvent(new PEventButton(this));
        if (clicked) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onButtonClick();
        }
        return clicked;
    }

    public Consumer<PanelButtonCustom> getCallback() {
        return this.callback;
    }

    public void setCallback(Consumer<PanelButtonCustom> callback) {
        this.callback = callback;
    }

    public PanelButtonCustom setTextures(IGuiTexture disabled, IGuiTexture idle, IGuiTexture hover) {
        this.texStates[0] = disabled;
        this.texStates[1] = idle;
        this.texStates[2] = hover;
        return this;
    }
}

