/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.questing.tasks.TaskLocation;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.StringUtils;

public class PanelTaskLocation
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final TaskLocation task;

    public PanelTaskLocation(IGuiRect rect, TaskLocation task) {
        super(rect);
        this.initialRect = rect;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int width = this.initialRect.getWidth();
        String desc = QuestTranslation.translate(this.task.name, new Object[0]);
        if (!this.task.hideInfo) {
            desc = desc + " (" + PanelTaskLocation.getDimName(this.task.dim) + ")";
            if (this.task.range >= 0) {
                desc = desc + "\n" + QuestTranslation.translate("bq_standard.gui.location", "(" + this.task.x + ", " + this.task.y + ", " + this.task.z + ")");
                desc = desc + "\n" + QuestTranslation.translate("bq_standard.gui.distance", (int)Minecraft.func_71410_x().field_71439_g.func_70011_f((double)this.task.x, (double)this.task.y, (double)this.task.z) + "m");
            }
            if (!StringUtils.isEmpty((CharSequence)this.task.biome)) {
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(this.task.biome));
                desc = desc + "\n" + QuestTranslation.translate("bq_standard.gui.biome", biome == null ? "?" : biome.func_185359_l());
            }
            if (!StringUtils.isNotEmpty((CharSequence)this.task.structure)) {
                desc = desc + "\n" + QuestTranslation.translate("bq_standard.gui.structure", this.task.structure);
            }
        }
        desc = this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) ? desc + "\n" + TextFormatting.BOLD + TextFormatting.GREEN + QuestTranslation.translate("bq_standard.gui.found", new Object[0]) : desc + "\n" + TextFormatting.BOLD + TextFormatting.RED + QuestTranslation.translate("bq_standard.gui.undiscovered", new Object[0]);
        int textHeight = (StringUtils.countMatches((CharSequence)desc, (CharSequence)"\n") + 1) * 12;
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 0, 0, width, textHeight, 0), desc).setColor(PresetColor.TEXT_MAIN.getColor()));
        IGuiTexture texCompass = new IGuiTexture(){

            @Override
            public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick) {
                this.drawTexture(x, y, width, height, zDepth, partialTick, null);
            }

            @Override
            public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
                Minecraft mc = Minecraft.func_71410_x();
                double la = Math.atan2((double)((PanelTaskLocation)PanelTaskLocation.this).task.z - mc.field_71439_g.field_70161_v, (double)((PanelTaskLocation)PanelTaskLocation.this).task.x - mc.field_71439_g.field_70165_t);
                int radius = width / 2 - 12;
                int cx = x + width / 2;
                int cy = y + height / 2;
                int dx = (int)(Math.cos(la) * (double)radius);
                int dy = (int)(Math.sin(la) * (double)(-radius));
                int txtClr = color == null ? -1 : color.getRGB();
                Gui.func_73734_a((int)(cx - radius), (int)(cy - radius), (int)(cx + radius), (int)(cy + radius), (int)Color.BLACK.getRGB());
                RenderUtils.DrawLine(cx - radius, cy - radius, cx + radius, cy - radius, 4.0f, txtClr);
                RenderUtils.DrawLine(cx - radius, cy - radius, cx - radius, cy + radius, 4.0f, txtClr);
                RenderUtils.DrawLine(cx + radius, cy + radius, cx + radius, cy - radius, 4.0f, txtClr);
                RenderUtils.DrawLine(cx + radius, cy + radius, cx - radius, cy + radius, 4.0f, txtClr);
                mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "N", cx - 4, cy - radius - 9, txtClr);
                mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "S", cx - 4, cy + radius + 2, txtClr);
                mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "E", cx + radius + 2, cy - 4, txtClr);
                mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "W", cx - radius - 8, cy - 4, txtClr);
                if (((PanelTaskLocation)PanelTaskLocation.this).task.hideInfo || ((PanelTaskLocation)PanelTaskLocation.this).task.range < 0 || mc.field_71439_g.field_71093_bK != ((PanelTaskLocation)PanelTaskLocation.this).task.dim) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                    mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "?", cx / 2 - 4, cy / 2 - 4, Color.RED.getRGB());
                    GlStateManager.func_179121_F();
                } else {
                    RenderUtils.DrawLine(cx, cy, cx + dx, cy - dy, 4.0f, Color.RED.getRGB());
                }
            }

            @Override
            public ResourceLocation getTexture() {
                return null;
            }

            @Override
            public IGuiRect getBounds() {
                return null;
            }
        };
        int innerSize = Math.min(Math.min(this.initialRect.getWidth(), 128), this.initialRect.getHeight() - textHeight);
        PanelGeneric panelCompass = new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, (width - innerSize) / 2, textHeight, innerSize, innerSize, 0), texCompass, PresetColor.TEXT_MAIN.getColor());
        this.addPanel(panelCompass);
        panelCompass.setEnabled(this.task.range >= 0 && !this.task.hideInfo);
        this.recalculateSizes();
    }

    private static String getDimName(int dim) {
        try {
            return DimensionType.func_186069_a((int)dim).func_186065_b();
        }
        catch (Exception e) {
            return "?";
        }
    }
}

