/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.asm;

import com.github.vfyjxf.jeiutilities.JEIUtilities;
import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class JeiUtilitiesClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassReader classReader;
        ClassNode classNode;
        String internalName = this.toInternalClassName(transformedName);
        if ("mezz/jei/gui/recipes/RecipesGui".equals(internalName) && JeiUtilitiesConfig.isEnableHistory()) {
            classNode = new ClassNode();
            classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                if (!"show".equals(methodNode.name)) continue;
                JEIUtilities.logger.info("Transforming : " + internalName + ";" + methodNode.name + methodNode.desc);
                AbstractInsnNode target = methodNode.instructions.getFirst();
                while (target.getOpcode() != 177) {
                    target = target.getNext();
                }
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/vfyjxf/jeiutilities/jei/JeiHooks", "onSetFocus", "(Lmezz/jei/api/recipe/IFocus;)V", false));
                methodNode.instructions.insertBefore(target, insnList);
                ClassWriter classWriter = new ClassWriter(3);
                classNode.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
        }
        if ("mezz/jei/startup/JeiStarter".equals(internalName)) {
            classNode = new ClassNode();
            classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                MethodInsnNode methodInsnNode;
                if (!"start".equals(methodNode.name)) continue;
                JEIUtilities.logger.info("Transforming : " + internalName + ";" + methodNode.name + methodNode.desc);
                AbstractInsnNode target = methodNode.instructions.getFirst();
                for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                    if (node.getOpcode() == 187 && node instanceof TypeInsnNode) {
                        TypeInsnNode typeInsnNode = (TypeInsnNode)node;
                        if ("mezz/jei/gui/overlay/bookmarks/BookmarkOverlay".equals(typeInsnNode.desc)) {
                            methodNode.instructions.remove(typeInsnNode.getNext());
                            methodNode.instructions.remove((AbstractInsnNode)typeInsnNode);
                        }
                        if ("mezz/jei/bookmarks/BookmarkList".equals(typeInsnNode.desc)) {
                            methodNode.instructions.remove(typeInsnNode.getNext());
                            methodNode.instructions.remove((AbstractInsnNode)typeInsnNode);
                        }
                    }
                    if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
                    methodInsnNode = (MethodInsnNode)node;
                    if ("mezz/jei/gui/overlay/bookmarks/BookmarkOverlay".equals(methodInsnNode.owner) && "<init>".equals(methodInsnNode.name)) {
                        methodInsnNode.setOpcode(184);
                        methodInsnNode.owner = "com/github/vfyjxf/jeiutilities/gui/bookmark/AdvancedBookmarkOverlay";
                        methodInsnNode.name = "create";
                        methodInsnNode.desc = "(Lmezz/jei/bookmarks/BookmarkList;Lmezz/jei/gui/GuiHelper;Lmezz/jei/gui/GuiScreenHelper;)Lmezz/jei/gui/overlay/bookmarks/BookmarkOverlay;";
                    }
                    if (!"mezz/jei/bookmarks/BookmarkList".equals(methodInsnNode.owner) || !"<init>".equals(methodInsnNode.name)) continue;
                    methodInsnNode.setOpcode(184);
                    methodInsnNode.owner = "com/github/vfyjxf/jeiutilities/jei/bookmark/RecipeBookmarkList";
                    methodInsnNode.name = "create";
                    methodInsnNode.desc = "(Lmezz/jei/ingredients/IngredientRegistry;)Lmezz/jei/bookmarks/BookmarkList;";
                }
                target = null;
                for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                    if (node.getOpcode() != 182 || !(node instanceof MethodInsnNode)) continue;
                    methodInsnNode = (MethodInsnNode)node;
                    if (!"mezz/jei/bookmarks/BookmarkList".equals(methodInsnNode.owner) || !"loadBookmarks".equals(methodInsnNode.name)) continue;
                    target = methodInsnNode;
                    while (!(target instanceof LabelNode)) {
                        target = target.getPrevious();
                    }
                    break;
                }
                if (target == null) continue;
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 14));
                insnList.add((AbstractInsnNode)new MethodInsnNode(179, "com/github/vfyjxf/jeiutilities/jei/JeiUtilitiesPlugin", "recipeRegistry", "Lmezz/jei/api/IRecipeRegistry;", false));
                methodNode.instructions.insertBefore(target, insnList);
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private String toInternalClassName(String className) {
        return className.replace('.', '/');
    }
}

