/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.config;

import com.github.vfyjxf.jeiutilities.config.RecordMode;
import com.github.vfyjxf.jeiutilities.config.SplittingMode;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="jeiutilities")
public class JeiUtilitiesConfig {
    private static final String CATEGORY_HISTORY = "history";
    private static final String CATEGORY_BOOKMARK = "bookmark";
    private static final String CATEGORY_RENDER = "render";
    private static Configuration config;
    private static File modConfigFile;
    private static boolean enableHistory;
    private static int useRows;
    private static boolean matchesNBTs;
    private static SplittingMode splittingMode;
    private static int backgroundColour;
    private static boolean recordRecipes;
    private static boolean showRecipeBookmarkReminders;
    private static RecordMode recordMode;
    private static boolean adaptiveRecipePreview;
    private static float recipePreviewScaling;

    public static void preInit(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "jeiutilities");
        modConfigFile = new File(configDir, "jeiutilities.cfg");
        config = new Configuration(modConfigFile);
        JeiUtilitiesConfig.loadConfig();
    }

    private static void loadConfig() {
        if (config == null) {
            return;
        }
        config.load();
        enableHistory = config.getBoolean("enableHistory", CATEGORY_HISTORY, enableHistory, "Enable browsing history function");
        useRows = config.getInt("useRows", CATEGORY_HISTORY, useRows, 1, 6, "Number of rows to use for history");
        matchesNBTs = config.getBoolean("matchesNBTs", CATEGORY_HISTORY, matchesNBTs, "Add item with different nbt to the browsing history");
        try {
            splittingMode = SplittingMode.valueOf(config.getString("splittingMode", CATEGORY_HISTORY, SplittingMode.DOTTED_LINE.name(), "Splitting mode for the browsing history.\nMode : BACKGROUND, DOTTED_LINE"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            splittingMode = SplittingMode.DOTTED_LINE;
        }
        backgroundColour = config.getInt("backgroundColour", CATEGORY_HISTORY, backgroundColour, Integer.MIN_VALUE, Integer.MAX_VALUE, "Color of the history area display");
        recordRecipes = config.getBoolean("recordRecipes", CATEGORY_BOOKMARK, recordRecipes, "Record current recipe when add ingredient to bookmark in recipe screen");
        showRecipeBookmarkReminders = config.getBoolean("showRecipeBookmarkReminders", CATEGORY_BOOKMARK, showRecipeBookmarkReminders, "Display a letter \"R\" in the upper left corner of the recipe bookmark.");
        recordMode = RecordMode.valueOf(config.getString("recordMode", CATEGORY_BOOKMARK, recordMode.name(), "Current mode of recording recipes.\nEnable: The opposite of RESTRICTED mode\nDisable: Don't record any recipes\nRESTRICTED: You need to hold down Shift to view the recorded recipe or record recipe."));
        adaptiveRecipePreview = config.getBoolean("adaptiveRecipePreview", CATEGORY_RENDER, adaptiveRecipePreview, "If true, then the recipe preview will automatically select the appropriate scaling based on the screen size.");
        recipePreviewScaling = config.getFloat("recipePreviewScaling", CATEGORY_RENDER, recipePreviewScaling, 0.01f, 5.0f, "The scaling of the recipe preview.It is only used when adaptiveRecipePreview is false.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static File getModConfigFile() {
        return modConfigFile;
    }

    public static boolean isEnableHistory() {
        return enableHistory;
    }

    public static int getUseRows() {
        return useRows;
    }

    public static boolean isMatchesNBTs() {
        return matchesNBTs;
    }

    public static boolean getRecordRecipes() {
        return recordRecipes;
    }

    public static RecordMode getRecordMode() {
        return recordMode;
    }

    public static int getBackgroundColour() {
        return backgroundColour;
    }

    public static void setRecordMode(RecordMode mode) {
        recordMode = mode;
        config.get(CATEGORY_BOOKMARK, "recordMode", recordMode.name(), "Current mode of recording recipes").set(mode.name());
        config.save();
    }

    public static boolean isShowRecipeBookmarkReminders() {
        return showRecipeBookmarkReminders;
    }

    public static SplittingMode getSplittingMode() {
        return splittingMode;
    }

    public static boolean isAdaptiveRecipePreview() {
        return adaptiveRecipePreview;
    }

    public static float getRecipePreviewScaling() {
        return recipePreviewScaling;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("jeiutilities")) {
            if (config.hasChanged()) {
                config.save();
            }
            JeiUtilitiesConfig.loadConfig();
        }
    }

    static {
        enableHistory = true;
        useRows = 2;
        matchesNBTs = true;
        splittingMode = SplittingMode.DOTTED_LINE;
        backgroundColour = -296397483;
        recordRecipes = true;
        showRecipeBookmarkReminders = true;
        recordMode = RecordMode.ENABLE;
        adaptiveRecipePreview = true;
        recipePreviewScaling = 0.8f;
    }
}

