/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.bookmark;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.config.KeyBindings;
import com.github.vfyjxf.jeiutilities.gui.bookmark.BookmarkInputHandler;
import com.github.vfyjxf.jeiutilities.gui.bookmark.RecordConfigButton;
import com.github.vfyjxf.jeiutilities.gui.common.GuiInputHandler;
import com.github.vfyjxf.jeiutilities.gui.recipe.RecipePreviewWidget;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import java.awt.Rectangle;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.input.Keyboard;

public class AdvancedBookmarkOverlay
extends BookmarkOverlay {
    private static final int BUTTON_SIZE = 20;
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton recordConfigButton = RecordConfigButton.create(this);
    private final BookmarkInputHandler inputHandler;
    private RecipeInfo<?, ?> infoUnderMouse;
    private RecipePreviewWidget recipeLayout;

    public static BookmarkOverlay create(BookmarkList bookmarkList, GuiHelper guiHelper, GuiScreenHelper guiScreenHelper) {
        if (JeiUtilitiesConfig.getRecordRecipes()) {
            return new AdvancedBookmarkOverlay(bookmarkList, guiHelper, guiScreenHelper);
        }
        return new BookmarkOverlay(bookmarkList, guiHelper, guiScreenHelper);
    }

    private AdvancedBookmarkOverlay(BookmarkList bookmarkList, GuiHelper guiHelper, GuiScreenHelper guiScreenHelper) {
        super(bookmarkList, guiHelper, guiScreenHelper);
        this.contents = (IngredientGridWithNavigation)ObfuscationReflectionHelper.getPrivateValue(BookmarkOverlay.class, (Object)((Object)this), (String)"contents");
        this.inputHandler = BookmarkInputHandler.getInstance();
    }

    public void updateBounds(@Nonnull Rectangle area, @Nonnull Set<Rectangle> guiExclusionAreas) {
        super.updateBounds(area, guiExclusionAreas);
        Rectangle rectangle = new Rectangle(area);
        rectangle.x = this.contents.getArea().x;
        rectangle.width = this.contents.getArea().width;
        this.recordConfigButton.updateBounds(new Rectangle(rectangle.x + 20 + 2, (int)Math.floor(rectangle.getMaxY()) - 20 - 2, 20, 20));
    }

    public void drawScreen(@Nonnull Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(minecraft, mouseX, mouseY, partialTicks);
        this.recordConfigButton.draw(minecraft, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        Object ingredientUnderMouse;
        boolean isTransferRecipeMax;
        boolean isTransferRecipe;
        boolean renderRecipe = false;
        boolean shouldRenderRecipe = false;
        int eventKey = Keyboard.getEventKey();
        boolean displayRecipe = KeyBindings.isKeyDown(KeyBindings.displayRecipe, false);
        if (displayRecipe | (isTransferRecipe = KeyBindings.isKeyDown(KeyBindings.transferRecipe)) | (isTransferRecipeMax = KeyBindings.isKeyDown(KeyBindings.transferRecipeMax)) && (ingredientUnderMouse = this.getIngredientUnderMouse()) instanceof RecipeInfo) {
            RecipePreviewWidget recipeLayout;
            RecipeInfo recipeInfo = (RecipeInfo)ingredientUnderMouse;
            shouldRenderRecipe = true;
            if (this.infoUnderMouse == recipeInfo) {
                recipeLayout = this.recipeLayout;
            } else {
                this.infoUnderMouse = recipeInfo;
                this.recipeLayout = recipeLayout = RecipePreviewWidget.createLayout(recipeInfo, mouseX, mouseY);
            }
            if (recipeLayout != null && displayRecipe) {
                this.updatePosition(mouseX, mouseY);
                recipeLayout.drawRecipe(minecraft, mouseX, mouseY);
                renderRecipe = true;
            }
        }
        if (!GuiInputHandler.isContainerTextFieldFocused() && !JeiUtilitiesPlugin.ingredientListOverlay.hasKeyboardFocus() && (isTransferRecipe || isTransferRecipeMax) && shouldRenderRecipe && this.recipeLayout != null && this.recipeLayout.getTransferError() != null) {
            if (!renderRecipe) {
                this.recipeLayout.drawRecipe(minecraft, mouseX, mouseY);
                renderRecipe = true;
            }
            this.recipeLayout.showError(minecraft, mouseX, mouseY);
        }
        if (!renderRecipe) {
            super.drawTooltips(minecraft, mouseX, mouseY);
            this.recordConfigButton.drawTooltips(minecraft, mouseX, mouseY);
        }
        if (this.inputHandler.getDraggedElement() != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            IIngredientRenderer ingredientRenderer = this.inputHandler.getDraggedElement().getIngredientRenderer();
            ingredientRenderer.render(minecraft, mouseX, mouseY, this.inputHandler.getDraggedElement().getIngredient());
            GlStateManager.func_179121_F();
        }
    }

    private void updatePosition(int mouseX, int mouseY) {
        int y;
        int x;
        Rectangle area;
        if (this.recipeLayout != null && !(area = new Rectangle((x = this.recipeLayout.getPosX()) - IngredientGrid.INGREDIENT_WIDTH, (y = this.recipeLayout.getPosY()) - IngredientGrid.INGREDIENT_WIDTH, IngredientGrid.INGREDIENT_WIDTH * 2, IngredientGrid.INGREDIENT_HEIGHT * 2)).contains(mouseX, mouseY)) {
            this.recipeLayout.setPosition(mouseX, mouseY);
        }
    }

    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean result = super.handleMouseClicked(mouseX, mouseY, mouseButton);
        if (this.recordConfigButton.isMouseOver(mouseX, mouseY)) {
            return this.recordConfigButton.handleMouseClick(mouseX, mouseY);
        }
        return result;
    }

    public RecipeInfo<?, ?> getInfoUnderMouse() {
        return this.infoUnderMouse;
    }

    public RecipePreviewWidget getRecipeLayout() {
        return this.recipeLayout;
    }

    public void setInfoUnderMouse(RecipeInfo<?, ?> infoUnderMouse) {
        this.infoUnderMouse = infoUnderMouse;
    }

    public void setRecipeLayout(RecipePreviewWidget recipeLayout) {
        this.recipeLayout = recipeLayout;
    }
}

