/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.bookmark;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.config.KeyBindings;
import com.github.vfyjxf.jeiutilities.config.RecordMode;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.util.Translator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class RecordConfigButton
extends GuiIconToggleButton {
    private RecordMode currentMode = JeiUtilitiesConfig.getRecordMode();
    private final BookmarkOverlay bookmarkOverlay;

    public static RecordConfigButton create(BookmarkOverlay bookmarkOverlay) {
        IDrawableStatic offIcon = JeiUtilitiesPlugin.guiHelper.drawableBuilder(new ResourceLocation("jeiutilities:textures/gui/icon/bookmark_button_config_disable.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        IDrawableStatic onIcon = JeiUtilitiesPlugin.guiHelper.drawableBuilder(new ResourceLocation("jeiutilities:textures/gui/icon/bookmark_button_config_enable.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        return new RecordConfigButton((IDrawable)offIcon, (IDrawable)onIcon, bookmarkOverlay);
    }

    private RecordConfigButton(IDrawable offIcon, IDrawable onIcon, BookmarkOverlay bookmarkOverlay) {
        super(offIcon, onIcon);
        this.bookmarkOverlay = bookmarkOverlay;
    }

    public void setRecordMode(RecordMode mode) {
        this.currentMode = mode;
    }

    public void getTooltips(@Nonnull List<String> tooltip) {
        tooltip.add(Translator.translateToLocal((String)"jeiutilities.tooltip.recording"));
        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jeiutilities.tooltip.recording.mode", (Object[])new Object[]{this.currentMode.getLocalizedName()}));
        if (this.currentMode == RecordMode.RESTRICTED) {
            tooltip.add(TextFormatting.GRAY + Translator.translateToLocal((String)"jeiutilities.tooltip.recording.description.restricted"));
        }
        if (this.currentMode == RecordMode.ENABLE) {
            tooltip.add(TextFormatting.GRAY + Translator.translateToLocal((String)"jeiutilities.tooltip.recording.description.enable"));
        }
        if (this.currentMode != RecordMode.DISABLE) {
            tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jeiutilities.tooltip.recording.information_1", (Object[])new Object[]{KeyBindings.displayRecipe.getDisplayName()}));
        }
    }

    public boolean isIconToggledOn() {
        return this.currentMode != RecordMode.DISABLE;
    }

    public boolean onMouseClicked(int mouseX, int mouseY) {
        if (this.bookmarkOverlay.hasRoom()) {
            int ordinal;
            int n = ordinal = Mouse.getEventButton() != 2 ? this.currentMode.ordinal() + 1 : this.currentMode.ordinal() - 1;
            if (ordinal >= RecordMode.values().length) {
                ordinal = 0;
            }
            if (ordinal < 0) {
                ordinal = RecordMode.values().length - 1;
            }
            this.setRecordMode(RecordMode.values()[ordinal]);
            JeiUtilitiesConfig.setRecordMode(this.currentMode);
            return true;
        }
        return false;
    }
}

