/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.common.block;

import com.robrit.snad.common.item.IMetaBlockSnad;
import com.robrit.snad.common.util.ConfigurationData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSnad
extends BlockFalling
implements IMetaBlockSnad {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final String BLOCK_IDENTIFIER = "snad";

    public BlockSnad() {
        super(Material.field_151595_p);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149663_c(BLOCK_IDENTIFIER);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.SNAD)));
        this.setRegistryName(new ResourceLocation(BLOCK_IDENTIFIER, BLOCK_IDENTIFIER));
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blockType : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockType.getMetadata()));
        }
    }

    @Deprecated
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getDustColor();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (blockAbove instanceof BlockReed || blockAbove instanceof BlockCactus) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                if (world.func_180495_p(pos.func_177981_b(height)).func_177230_c() != null) {
                    Block nextPlantBlock = world.func_180495_p(pos.func_177981_b(height)).func_177230_c();
                    if (nextPlantBlock.getClass() == blockAbove.getClass()) {
                        for (int growthAttempts = 0; growthAttempts < ConfigurationData.SPEED_INCREASE_VALUE; ++growthAttempts) {
                            if (!(growthAttempts == 0 | this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, null, (IPlantable)blockAbove))) continue;
                            nextPlantBlock.func_180650_b(world, pos.func_177981_b(height), world.func_180495_p(pos.func_177981_b(height)), rand);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        } else if (blockAbove instanceof IPlantable) {
            blockAbove.func_180650_b(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()), rand);
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        BlockPos plantPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        EnumPlantType plantType = plantable.getPlantType(world, plantPos);
        switch (plantType) {
            case Desert: {
                return true;
            }
            case Water: {
                return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h && world.func_180495_p(pos) == this.func_176223_P();
            }
            case Beach: {
                return world.func_180495_p(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)).func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() == 0 ? "default" : "red";
    }

    public static enum EnumType implements IStringSerializable
    {
        SNAD(0, "snad", "default", MapColor.field_151658_d, -2370656),
        RED_SNAD(1, "red_snad", "red", MapColor.field_151676_q, -5679071);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;
        private final String unlocalizedName;
        private final int dustColor;

        private EnumType(int meta, String name, String unlocalizedName, MapColor mapColor, int dustColor) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.mapColor = mapColor;
            this.dustColor = dustColor;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        @SideOnly(value=Side.CLIENT)
        public int getDustColor() {
            return this.dustColor;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockType;
                EnumType.META_LOOKUP[blockType.getMetadata()] = blockType = enumTypeArray[i];
            }
        }
    }
}

