/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import javax.annotation.Nonnull;
import mcjty.lostcities.config.BiomeSelectionStrategy;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.ModDimensions;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.LostWorldFilteredBiomeProvider;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.setup.ModSetup;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class LostWorldProvider
extends WorldProvider {
    @Nonnull
    public DimensionType func_186058_p() {
        return ModDimensions.lostDimensionType;
    }

    @Nonnull
    public String getSaveFolder() {
        if (this.getDimension() == LostCityConfiguration.DIMENSION_ID) {
            return "LOST";
        }
        return "LOST" + this.getDimension();
    }

    @Nonnull
    public IChunkGenerator func_186060_c() {
        return new LostCityChunkGenerator(this.field_76579_a, this.field_76579_a.func_72905_C() >> 3 ^ 0x7FE293405L);
    }

    private BiomeProvider getInternalBiomeProvider(World world) {
        if (this.field_76578_c == null) {
            for (WorldType type : WorldType.field_77139_a) {
                if (!"BIOMESOP".equals(type.func_77127_a())) continue;
                WorldType orig = world.func_72912_H().func_76067_t();
                world.func_72912_H().func_76085_a(type);
                this.field_76578_c = type.getBiomeProvider(world);
                world.func_72912_H().func_76085_a(orig);
                break;
            }
        }
        return this.field_76578_c;
    }

    protected void func_76572_b() {
        super.func_76572_b();
        String profileName = ModDimensions.dimensionProfileMap.get(this.field_76579_a.field_73011_w.getDimension());
        LostCityProfile profile = LostCityConfiguration.profiles.get(profileName);
        if (profile == null) {
            profile = WorldTypeTools.getProfile(this.field_76579_a);
        }
        BiomeProvider biomeProvider = ModSetup.biomesoplenty && LostCityConfiguration.DIMENSION_BOP ? this.getInternalBiomeProvider(this.field_76579_a) : new BiomeProvider(this.field_76579_a.func_72912_H());
        if (profile.ALLOWED_BIOME_FACTORS.length == 0) {
            this.field_76578_c = biomeProvider;
        } else {
            String[] outsideAllowedbiomeFactors = profile.ALLOWED_BIOME_FACTORS;
            String[] outsideManualBiomeMapping = profile.MANUAL_BIOME_MAPPINGS;
            BiomeSelectionStrategy outsideStrategy = null;
            if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE && !profile.CITYSPHERE_OUTSIDE_PROFILE.isEmpty()) {
                LostCityProfile outProfile = LostCityConfiguration.profiles.get(profile.CITYSPHERE_OUTSIDE_PROFILE);
                outsideAllowedbiomeFactors = outProfile.ALLOWED_BIOME_FACTORS;
                outsideManualBiomeMapping = outProfile.MANUAL_BIOME_MAPPINGS;
                outsideStrategy = outProfile.BIOME_SELECTION_STRATEGY;
            }
            this.field_76578_c = new LostWorldFilteredBiomeProvider(this.field_76579_a, biomeProvider, profile.ALLOWED_BIOME_FACTORS, profile.MANUAL_BIOME_MAPPINGS, profile.BIOME_SELECTION_STRATEGY, outsideAllowedbiomeFactors, outsideManualBiomeMapping, outsideStrategy);
        }
    }
}

