/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.bansoukou;

import com.google.common.eventbus.EventBus;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.misc.URLClassPath;

@IFMLLoadingPlugin.Name(value="-Bansoukou-")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-2147483648)
public class BansoukouCoreMod
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Bansoukou");
    static Map<String, Path> scheduledDeletion = new Object2ObjectOpenHashMap();
    static Map<String, String> patchedStrings = new Object2ObjectOpenHashMap();
    static Map<URL, URL> patchedUrls = new Object2ObjectOpenHashMap();
    File modsFolder;

    public BansoukouCoreMod() {
        LOGGER.info("Ikimasu!");
        File rootFolder = Launch.minecraftHome == null ? new File(".") : Launch.minecraftHome;
        File bansoukouRoot = new File(rootFolder, "bansoukou");
        if (bansoukouRoot.mkdir()) {
            LOGGER.info("No bansoukou found. Perhaps it is the first load. Continuing with mod loading.");
            return;
        }
        File[] patchRoot = bansoukouRoot.listFiles();
        if (patchRoot == null) {
            LOGGER.info("No patches found. Continuing with mod loading.");
            return;
        }
        this.modsFolder = new File(rootFolder, "mods");
        Object2ObjectOpenHashMap jars = new Object2ObjectOpenHashMap(patchRoot.length);
        for (File file : patchRoot) {
            try {
                File patch = this.getPatchFile(this.modsFolder, file);
                if (patch == null) continue;
                jars.put(file, patch);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!jars.isEmpty()) {
            try {
                Field launchClassLoader$sources = LaunchClassLoader.class.getDeclaredField("sources");
                launchClassLoader$sources.setAccessible(true);
                Field field = URLClassLoader.class.getDeclaredField("ucp");
                field.setAccessible(true);
                Field urlClassPath$path = URLClassPath.class.getDeclaredField("path");
                urlClassPath$path.setAccessible(true);
                Field urlClassPath$urls = URLClassPath.class.getDeclaredField("urls");
                urlClassPath$urls.setAccessible(true);
                Field modFilenameFilterField = LibraryManager.class.getDeclaredField("MOD_FILENAME_FILTER");
                modFilenameFilterField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(modFilenameFilterField, modFilenameFilterField.getModifiers() & 0xFFFFFFEF);
                Field coreModManager$ignoredModFiles = CoreModManager.class.getDeclaredField("ignoredModFiles");
                coreModManager$ignoredModFiles.setAccessible(true);
                Field coreModManager$candidateModFiles = CoreModManager.class.getDeclaredField("candidateModFiles");
                coreModManager$candidateModFiles.setAccessible(true);
                launchClassLoader$sources.set(Launch.classLoader, this.getRedirectedAddUrlsList(Launch.classLoader.getSources()));
                URLClassPath urlClassPathInstance = (URLClassPath)field.get(Launch.classLoader);
                urlClassPath$path.set(urlClassPathInstance, this.getRedirectedAddUrlsList((List)urlClassPath$path.get(urlClassPathInstance)));
                urlClassPath$urls.set(urlClassPathInstance, this.getRedirectedAddUrlsStack((Stack)urlClassPath$urls.get(urlClassPathInstance)));
                FilenameFilter newFilter = (dir, name) -> !patchedStrings.containsKey(name) && (name.endsWith(".jar") || name.endsWith(".zip"));
                modFilenameFilterField.set(null, newFilter);
                coreModManager$ignoredModFiles.set(null, this.getRedirectedAddStringsList(CoreModManager.getIgnoredMods()));
                coreModManager$candidateModFiles.set(null, this.getRedirectedAddStringsList(CoreModManager.getReparseableCoremods()));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            for (Map.Entry entry : jars.entrySet()) {
                File root = (File)entry.getKey();
                File zip = (File)entry.getValue();
                try {
                    FileSystem fs = FileSystems.newFileSystem(zip.toPath(), null);
                    Throwable throwable = null;
                    try {
                        Stream<Path> walk = Files.walk(root.toPath(), new FileVisitOption[0]);
                        Throwable throwable2 = null;
                        try {
                            walk.map(Path::toFile).filter(f -> !f.isDirectory() || f.toString().endsWith(".DELETION")).forEach(f -> {
                                Path currentPath;
                                if (f.isDirectory()) {
                                    String fileUri = f.toURI().toString();
                                    fileUri = fileUri.substring(0, fileUri.lastIndexOf(46));
                                    currentPath = fs.getPath(root.toURI().relativize(URI.create(fileUri)).toString(), new String[0]);
                                } else {
                                    currentPath = fs.getPath(root.toURI().relativize(f.toURI()).toString(), new String[0]);
                                }
                                try {
                                    this.patch((File)f, currentPath);
                                }
                                catch (IOException e) {
                                    if (e instanceof NoSuchFileException) {
                                        try {
                                            Files.createDirectories(currentPath, new FileAttribute[0]);
                                            this.patch((File)f, currentPath);
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                    e.printStackTrace();
                                }
                            });
                            Path meta$inf = fs.getPath("/META-INF", new String[0]);
                            if (!Files.exists(meta$inf, new LinkOption[0])) continue;
                            Files.walk(meta$inf, 1, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".SF")).forEach(p -> {
                                try {
                                    LOGGER.info("Wiping signature file from {}, as we have tampered with the file.", (Object)zip);
                                    Files.delete(p);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            });
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (walk == null) continue;
                            if (throwable2 != null) {
                                try {
                                    walk.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            walk.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        fs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getPatchFile(File mods, File patchFile) throws IOException {
        File modFile = new File(mods, patchFile.getName().concat(".jar"));
        if (Files.exists(modFile.toPath(), new LinkOption[0])) {
            block15: {
                try (RandomAccessFile raf = new RandomAccessFile(modFile, "r");){
                    int start = raf.readInt();
                    if (start == 1347093252 || start == 1347093766 || start == 1347094280) {
                        LOGGER.warn("{} was found in the mods folder. Copying to modify the copied cache.", (Object)modFile.getName());
                        break block15;
                    }
                    throw (ZipException)LOGGER.throwing((Throwable)new ZipException(modFile.getName() + " exists in the mods folder but isn't a valid jar/zip file!"));
                }
            }
            Path modFilePath = modFile.toPath();
            scheduledDeletion.put(patchFile.getName(), modFilePath);
            File newFile = new File(mods, patchFile.getName() + "-patched.jar").getCanonicalFile();
            Path newFilePath = newFile.toPath();
            Files.copy(modFilePath, newFilePath, StandardCopyOption.REPLACE_EXISTING);
            patchedStrings.put(modFilePath.getFileName().toString(), newFilePath.getFileName().toString());
            URL relativeUrl = modFile.toURI().toURL();
            patchedUrls.put(relativeUrl, newFile.toURI().toURL());
            LOGGER.warn("Marking {} to fool Forge's mod discovering mechanism.", (Object)relativeUrl);
            return newFile;
        }
        if (!new File(mods, patchFile.getName().concat(".disabled")).exists()) {
            throw (FileNotFoundException)LOGGER.throwing((Throwable)new FileNotFoundException(modFile.getName() + " does not exist in mods folder!"));
        }
        return null;
    }

    private void patch(File f, Path currentPath) throws IOException {
        if (f.isDirectory()) {
            LOGGER.warn("Removing {} folder and everything under it...", (Object)currentPath);
            Files.walkFileTree(currentPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (f.length() <= 0L) {
            LOGGER.warn("Removing {}...", (Object)currentPath);
            Files.deleteIfExists(currentPath);
        } else {
            LOGGER.warn("Patching {}...", (Object)currentPath);
            Files.copy(f.toPath(), currentPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private ArrayList<String> getRedirectedAddStringsList(List<String> existingList) {
        return new ArrayList<String>(existingList){

            @Override
            public boolean add(String o) {
                String patched = patchedStrings.get(o);
                return patched == null ? super.add(o) : super.add(patched);
            }
        };
    }

    private ArrayList<URL> getRedirectedAddUrlsList(List<URL> existingList) {
        return new ArrayList<URL>(existingList){

            @Override
            public boolean add(URL o) {
                URL patched = patchedUrls.get(o);
                return patched == null ? super.add(o) : super.add(patched);
            }
        };
    }

    private Stack<URL> getRedirectedAddUrlsStack(Stack<URL> existingStack) {
        Stack<URL> stack = new Stack<URL>(){

            @Override
            public void add(int index, URL o) {
                URL patched = patchedUrls.get(o);
                if (patched == null) {
                    super.add(index, o);
                } else {
                    super.add(index, patched);
                }
            }
        };
        stack.addAll(existingStack);
        return stack;
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.bansoukou.BansoukouCoreMod$Container";
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        scheduledDeletion.forEach((s, p) -> {
            try {
                File disabledFile = new File(this.modsFolder, s + ".disabled");
                Files.move(p, disabledFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        File disabledFile = new File(this.modsFolder, s + ".disabled");
                        Files.move(p, disabledFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }));
            }
        });
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            ModMetadata meta = this.getMetadata();
            meta.modId = "bansoukou";
            meta.name = "Bansoukou";
            meta.description = "A simple coremod that streamlines patching of mods.";
            meta.version = "4.3.1";
            meta.logoFile = "/icon.png";
            meta.authorList.add("Rongmario");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }
    }
}

