/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.energy;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.util.NbtComparer;
import info.loenwind.autoconfig.factory.IValue;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class EnergyUpgradeManager {
    @Nonnull
    protected static final String UPGRADE_NAME = "energyUpgrade";
    @Nonnull
    protected static final String HIGH_UPGRADE_NAME = "batteryUpgrade";
    @Nonnull
    protected static final String KEY_ENERGY = "energy";
    @Nonnull
    protected static final Random RANDOM = new Random();
    private static final NbtComparer energyInvarientNbtComparer = new NbtComparer();

    public static EnergyUpgrade.EnergyUpgradeHolder loadFromItem(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof IDarkSteelItem) {
            IDarkSteelItem item = (IDarkSteelItem)stack.func_77973_b();
            EnergyUpgrade energyUpgrade = EnergyUpgrade.loadAnyFromItem(stack);
            return energyUpgrade != null ? energyUpgrade.getEnergyUpgradeHolder(stack, item) : null;
        }
        return null;
    }

    public static boolean itemHasAnyPowerUpgrade(@Nonnull ItemStack itemstack) {
        return EnergyUpgrade.loadAnyFromItem(itemstack) != null;
    }

    public static int getPowerUpgradeLevel(@Nonnull ItemStack itemstack) {
        EnergyUpgrade upgrade = EnergyUpgrade.loadAnyFromItem(itemstack);
        return upgrade != null ? upgrade.getLevel() : -1;
    }

    public static boolean isLowestPowerUpgrade(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade instanceof EnergyUpgrade && ((EnergyUpgrade)upgrade).getLevel() == 0;
    }

    public static int extractEnergy(@Nonnull ItemStack container, int maxExtract, boolean simulate) {
        if (maxExtract > 0 && container.func_77973_b() instanceof IDarkSteelItem) {
            return EnergyUpgradeManager.extractEnergy(container, (IDarkSteelItem)container.func_77973_b(), maxExtract, simulate);
        }
        return 0;
    }

    public static int extractEnergy(@Nonnull ItemStack container, @Nonnull IDarkSteelItem item, int maxExtract, boolean simulate) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        int res = eu.extractEnergy(maxExtract, simulate);
        if (!simulate && res > 0) {
            eu.writeToItem();
        }
        return res;
    }

    public static int extractEnergy(@Nonnull ItemStack container, @Nonnull IDarkSteelItem item, IValue<Integer> maxExtract, boolean simulate) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        int res = eu.extractEnergy((Integer)maxExtract.get(), simulate);
        if (!simulate && res > 0) {
            eu.writeToItem();
        }
        return res;
    }

    public static int receiveEnergy(@Nonnull ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77973_b() instanceof IDarkSteelItem) {
            return EnergyUpgradeManager.receiveEnergy(container, (IDarkSteelItem)container.func_77973_b(), maxReceive, simulate);
        }
        return 0;
    }

    public static int receiveEnergy(@Nonnull ItemStack container, @Nonnull IDarkSteelItem item, int maxReceive, boolean simulate) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        int res = eu.receiveEnergy(maxReceive, simulate);
        if (!simulate && res > 0) {
            eu.writeToItem();
        }
        return res;
    }

    public static void setPowerFull(@Nonnull ItemStack container, @Nonnull IDarkSteelItem item) {
        if (!EnergyUpgradeManager.itemHasAnyPowerUpgrade(container)) {
            return;
        }
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        eu.setEnergy(eu.getCapacity());
        eu.writeToItem();
    }

    public static String getStoredEnergyString(@Nonnull ItemStack itemstack) {
        EnergyUpgrade.EnergyUpgradeHolder up = EnergyUpgradeManager.loadFromItem(itemstack);
        if (up == null) {
            return null;
        }
        return LangPower.RF(up.getEnergy(), up.getCapacity());
    }

    public static int getEnergyStored(@Nonnull ItemStack container) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        return eu.getEnergy();
    }

    public static int getMaxEnergyStored(@Nonnull ItemStack container) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(container);
        if (eu == null) {
            return 0;
        }
        return eu.getCapacity();
    }

    public static boolean compareNbt(NBTTagCompound oldNbt, NBTTagCompound newNbt) {
        return energyInvarientNbtComparer.compare(oldNbt, newNbt);
    }

    static {
        energyInvarientNbtComparer.addInvarientTagKey(KEY_ENERGY);
    }
}

