/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class FlatLampBlock
extends BlockDirectional {
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> SHAPES = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0)).put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0)).put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0)).put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0)).put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875)).put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0)).build());
    private static final IProperty<Boolean> ACTIVE = PropertyBool.func_177716_a((String)"active");

    public FlatLampBlock() {
        super(Material.field_151592_s);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.UP));
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b(ACTIVE) != false ? 15 : 0;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return state.func_177229_b((IProperty)field_176387_N) == facing.func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)SHAPES.get((Object)state.func_177229_b((IProperty)field_176387_N));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            boolean powered = world.func_175640_z(pos);
            if ((Boolean)state.func_177229_b(ACTIVE) != powered) {
                world.func_180501_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean active = (Boolean)state.func_177229_b(ACTIVE);
        boolean powered = world.func_175640_z(pos);
        if (active && !powered) {
            world.func_175684_a(pos, (Block)this, 4);
        } else if (!active && powered) {
            world.func_180501_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        if (!world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, false)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        if (side != facing.func_176734_d()) {
            IBlockState other = access.func_180495_p(pos.func_177972_a(side));
            return this == other.func_177230_c() && facing.func_176740_k() == ((EnumFacing)other.func_177229_b((IProperty)field_176387_N)).func_176740_k();
        }
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos offset = pos.func_177972_a(side.func_176734_d());
        return world.func_180495_p(offset).func_193401_d((IBlockAccess)world, offset, side) == BlockFaceShape.SOLID;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        boolean active = meta >> 3 == 1;
        EnumFacing facing = EnumFacing.values()[meta & 7];
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing).func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public int func_176201_c(IBlockState state) {
        int active = ((Boolean)state.func_177229_b(ACTIVE) != false ? 1 : 0) << 3;
        int facing = ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).ordinal();
        return facing | active;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, field_176387_N});
    }
}

