/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.network;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class XtoneCycleMessage
implements IMessage {
    private static final int SIZE_BYTES = 4;
    private static final EnumHand[] HANDS = EnumHand.values();
    private static final int ABSENT = 0;
    private static final int NEXT = 1;
    private static final int PREV = -1;
    private static final int INVALID_SLOT = -2;
    private static final int OFF_HAND_SLOT = -1;
    private @MonotonicNonNull EnumHand hand;
    private int offset = 0;
    private int slot = -2;

    @Deprecated
    public XtoneCycleMessage() {
    }

    XtoneCycleMessage(EntityPlayer player, EnumHand hand, int scroll) {
        this.hand = hand;
        this.offset = scroll >= 0 ? 1 : -1;
        this.slot = XtoneCycleMessage.isMain(hand) ? XtoneCycleMessage.checkSlot(hand, player.field_71071_by.field_70461_c) : -1;
    }

    private static boolean isMain(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND;
    }

    private static int checkSlot(EnumHand hand, int slot) {
        boolean hotbar = XtoneCycleMessage.isMain(hand) && InventoryPlayer.func_184435_e((int)slot);
        Preconditions.checkArgument((hotbar || slot == -1 ? 1 : 0) != 0, (Object)slot);
        return slot;
    }

    EnumHand getHand() {
        Preconditions.checkState((this.hand != null ? 1 : 0) != 0);
        return this.hand;
    }

    int getOffset() {
        Preconditions.checkState((this.offset != 0 ? 1 : 0) != 0);
        return this.offset;
    }

    int getExpectedSlot() {
        Preconditions.checkState((this.slot != -2 ? 1 : 0) != 0);
        return this.slot;
    }

    public void fromBytes(ByteBuf buf) {
        Preconditions.checkArgument((boolean)buf.isReadable(4), (Object)buf);
        this.offset = buf.readBoolean() ? 1 : -1;
        this.hand = HANDS[buf.readByte()];
        this.slot = XtoneCycleMessage.checkSlot(this.hand, buf.readShort());
    }

    public void toBytes(ByteBuf buf) {
        Preconditions.checkArgument((boolean)buf.isWritable(4), (Object)buf);
        buf.writeBoolean(this.offset == 1);
        buf.writeByte(this.hand.ordinal());
        buf.writeShort(this.slot);
    }
}

