/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.category;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.gui.provided.book.helper.TranslationHolder;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.category.ComponentCategoryPage;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.Entry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00162\u0006\u0010\u0002\u001a\u000201H\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u001a\u0010!\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010 \"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0014\u00a8\u00062"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/category/Category;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/IBookElement;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "json", "Lcom/google/gson/JsonObject;", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;Lcom/google/gson/JsonObject;)V", "bindingColor", "Ljava/awt/Color;", "getBindingColor", "()Ljava/awt/Color;", "getBook", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "bookParent", "getBookParent", "color", "getColor", "desc", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "getDesc", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "entries", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "getEntries", "()Ljava/util/List;", "icon", "Lcom/google/gson/JsonElement;", "getIcon", "()Lcom/google/gson/JsonElement;", "isSingleEntry", "", "()Z", "isValid", "setValid", "(Z)V", "outerColor", "getOuterColor", "sheet", "", "getSheet", "()Ljava/lang/String;", "title", "getTitle", "anyUnlocked", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createComponents", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/context/PaginationContext;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "librarianlib-1.12.2"})
public final class Category
implements IBookElement {
    @NotNull
    private final List<Entry> entries;
    @Nullable
    private final TranslationHolder title;
    @Nullable
    private final TranslationHolder desc;
    @NotNull
    private final JsonElement icon;
    @NotNull
    private final Color color;
    @NotNull
    private final String sheet;
    @NotNull
    private final Color outerColor;
    @NotNull
    private final Color bindingColor;
    private boolean isValid;
    @NotNull
    private final Book book;

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    @Nullable
    public final TranslationHolder getTitle() {
        return this.title;
    }

    @Nullable
    public final TranslationHolder getDesc() {
        return this.desc;
    }

    @NotNull
    public final JsonElement getIcon() {
        return this.icon;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final String getSheet() {
        return this.sheet;
    }

    @NotNull
    public final Color getOuterColor() {
        return this.outerColor;
    }

    @NotNull
    public final Color getBindingColor() {
        return this.bindingColor;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public final boolean isSingleEntry() {
        return this.entries.size() == 1;
    }

    @Override
    @NotNull
    public Book getBookParent() {
        return this.book;
    }

    public final boolean anyUnlocked(@NotNull EntityPlayer player) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(player, "player");
            Iterable $receiver$iv = this.entries;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Entry it = (Entry)element$iv;
                    if (!it.isUnlocked(player)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        List list2;
        Intrinsics.checkParameterIsNotNull(book, "book");
        if (this.isSingleEntry()) {
            list2 = this.entries.get(0).createComponents(book);
        } else {
            book.updateTextureData(this.sheet, this.outerColor, this.bindingColor);
            int n = ComponentCategoryPage.Companion.numberOfPages(this);
            ArrayList<PaginationContext> arrayList = new ArrayList<PaginationContext>(n);
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void it;
                int n4;
                int n5 = n4 = n2++;
                ArrayList<PaginationContext> arrayList2 = arrayList;
                PaginationContext paginationContext = new PaginationContext((Function0<? extends GuiComponent>)new Function0<ComponentCategoryPage>((int)it, this, book){
                    final /* synthetic */ int $it;
                    final /* synthetic */ Category this$0;
                    final /* synthetic */ IBookGui $book$inlined;
                    {
                        this.$it = n;
                        this.this$0 = category;
                        this.$book$inlined = iBookGui;
                        super(0);
                    }

                    @NotNull
                    public final ComponentCategoryPage invoke() {
                        return new ComponentCategoryPage(this.$book$inlined, this.this$0, this.$it);
                    }
                });
                arrayList2.add(paginationContext);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public final Book getBook() {
        return this.book;
    }

    public Category(@NotNull Book book, @NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull(book, "book");
        Intrinsics.checkParameterIsNotNull(json, "json");
        this.book = book;
        TranslationHolder title = null;
        TranslationHolder desc = null;
        JsonElement icon = (JsonElement)new JsonObject();
        List entries = new ArrayList();
        Color color2 = this.book.getHighlightColor();
        String sheet = this.book.getTextureSheet();
        Color outerColor = this.book.getBookColor();
        Color bindingColor = this.book.getBindingColor();
        try {
            boolean bl;
            title = TranslationHolder.Companion.fromJson(json.get("title"));
            desc = TranslationHolder.Companion.fromJson(json.get("description"));
            JsonElement jsonElement = json.get("icon");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json.get(\"icon\")");
            icon = jsonElement;
            if (json.has("color")) {
                JsonElement jsonElement2 = json.get("color");
                Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "json.get(\"color\")");
                color2 = Book.Companion.colorFromJson(jsonElement2);
            }
            if (json.has("style")) {
                JsonObject obj = json.getAsJsonObject("style");
                if (obj.has("sheet")) {
                    JsonPrimitive jsonPrimitive = obj.getAsJsonPrimitive("sheet");
                    Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "obj.getAsJsonPrimitive(\"sheet\")");
                    String string = jsonPrimitive.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull(string, "obj.getAsJsonPrimitive(\"sheet\").asString");
                    sheet = string;
                }
                if (obj.has("color")) {
                    JsonElement jsonElement3 = obj.get("color");
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement3, "obj.get(\"color\")");
                    outerColor = Book.Companion.colorFromJson(jsonElement3);
                }
                if (obj.has("binding")) {
                    JsonElement jsonElement4 = obj.get("binding");
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement4, "obj.get(\"binding\")");
                    bindingColor = Book.Companion.colorFromJson(jsonElement4);
                }
            }
            JsonArray allEntries = json.getAsJsonArray("entries");
            Iterator iterator2 = allEntries.iterator();
            while (iterator2.hasNext()) {
                JsonElement entryJson;
                JsonElement jsonElement5 = entryJson = (JsonElement)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(jsonElement5, "entryJson");
                String string = jsonElement5.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "entryJson.asString");
                JsonElement parsable = Book.Companion.getJsonFromLink(string);
                String string2 = entryJson.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "entryJson.asString");
                JsonElement jsonElement6 = parsable;
                if (jsonElement6 == null) {
                    Intrinsics.throwNpe();
                }
                JsonObject jsonObject = jsonElement6.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull(jsonObject, "parsable!!.asJsonObject");
                Entry entry = new Entry(this.book, sheet, outerColor, bindingColor, string2, jsonObject);
                if (!entry.isValid()) continue;
                entries.add(entry);
            }
            Collection collection = entries;
            Category category = this;
            category.isValid = bl = !collection.isEmpty();
        }
        catch (Exception exception) {
            LibrarianLog.INSTANCE.error(exception, "Failed trying to parse a category component", new Object[0]);
        }
        this.title = title;
        this.desc = desc;
        this.icon = icon;
        this.entries = entries;
        this.color = color2;
        this.sheet = sheet;
        this.outerColor = outerColor;
        this.bindingColor = bindingColor;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<Bookmark> addAllBookmarks(@Nullable List<? extends Bookmark> list2) {
        return IBookElement.DefaultImpls.addAllBookmarks(this, list2);
    }
}

