/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.google.gson.JsonObject;

public interface IDrawable {
    public static final IDrawable EMPTY = (context, x, y, width, height) -> {};

    public void draw(GuiContext var1, int var2, int var3, int var4, int var5);

    default public void draw(GuiContext context, int width, int height) {
        this.draw(context, 0, 0, width, height);
    }

    default public void draw(GuiContext context, Area area) {
        this.draw(context, area.x, area.y, area.width, area.height);
    }

    default public void drawAtZero(GuiContext context, Area area) {
        this.draw(context, 0, 0, area.width, area.height);
    }

    default public void applyThemeColor(ITheme theme, WidgetTheme widgetTheme) {
        Color.setGlColorOpaque(Color.WHITE.normal);
    }

    default public boolean canApplyTheme() {
        return false;
    }

    default public Widget<?> asWidget() {
        return new DrawableWidget(this);
    }

    default public Icon asIcon() {
        return new Icon(this);
    }

    default public void loadFromJson(JsonObject json) {
    }

    public static class DrawableWidget
    extends Widget<DrawableWidget> {
        private final IDrawable drawable;

        public DrawableWidget(IDrawable drawable) {
            this.drawable = drawable;
        }

        @Override
        public void draw(GuiContext context) {
            this.drawable.drawAtZero(context, this.getArea());
        }
    }
}

