/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.AnimatedText;
import com.cleanroommc.modularui.drawable.StyledText;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.drawable.keys.CompoundKey;
import com.cleanroommc.modularui.drawable.keys.DynamicKey;
import com.cleanroommc.modularui.drawable.keys.LangKey;
import com.cleanroommc.modularui.drawable.keys.StringKey;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.google.gson.JsonObject;
import java.util.function.Supplier;

public interface IKey
extends IDrawable {
    public static final int TEXT_COLOR = -12566464;
    public static final TextRenderer renderer = new TextRenderer();
    public static final IKey EMPTY = new StringKey("");

    public static IKey lang(String key) {
        return new LangKey(key);
    }

    public static IKey format(String key, Object ... args) {
        return new LangKey(key).args(args);
    }

    public static IKey str(String key) {
        return new StringKey(key);
    }

    public static IKey comp(IKey ... keys) {
        return new CompoundKey(keys);
    }

    public static IKey dynamic(Supplier<String> getter) {
        return new DynamicKey(getter);
    }

    public String get();

    @Deprecated
    public void set(String var1);

    @Override
    default public void draw(GuiContext context, int x, int y, int width, int height) {
        renderer.setAlignment(Alignment.Center, width, height);
        renderer.setScale(1.0f);
        renderer.setPos(x, y);
        renderer.draw(this.get());
    }

    @Override
    default public void applyThemeColor(ITheme theme, WidgetTheme widgetTheme) {
        renderer.setColor(widgetTheme.getTextColor());
        renderer.setShadow(widgetTheme.getTextShadow());
    }

    default public TextWidget asWidget() {
        return new TextWidget(this);
    }

    default public StyledText withStyle() {
        return new StyledText(this);
    }

    default public AnimatedText withAnimation() {
        return new AnimatedText(this);
    }

    default public StyledText alignment(Alignment alignment) {
        return this.withStyle().alignment(alignment);
    }

    default public StyledText color(int color) {
        return this.withStyle().color(color);
    }

    default public StyledText scale(float scale) {
        return this.withStyle().scale(scale);
    }

    default public StyledText shadow(boolean shadow) {
        return this.withStyle().shadow(shadow);
    }

    @Override
    default public void loadFromJson(JsonObject json) {
        if (json.has("color") || json.has("shadow") || json.has("align") || json.has("alignment") || json.has("scale")) {
            StyledText styledText;
            StyledText styledText2 = styledText = this instanceof StyledText ? (StyledText)this : this.withStyle();
            if (json.has("color")) {
                styledText.color(JsonHelper.getInt(json, 0, "color"));
            }
            styledText.shadow(JsonHelper.getBoolean(json, false, "shadow"));
            styledText.alignment(JsonHelper.deserialize(json, Alignment.class, styledText.getAlignment(), "align", "alignment"));
            styledText.scale(JsonHelper.getFloat(json, 1.0f, "scale"));
        }
    }
}

