/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.layout;

import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.IWidgetList;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import java.util.Stack;
import java.util.function.Predicate;

public interface IViewport {
    public static final int DRAWING = 1;
    public static final int INTERACTION = 2;
    public static final int PRE_DRAW = 4;
    public static final int POST_DRAW = 8;
    public static final int START_DRAGGING = 16;
    public static final int STOP_DRAGGING = 32;
    public static final int MOUSE = 64;
    public static final int KEY = 128;
    public static final int PRESSED = 256;
    public static final int RELEASED = 512;
    public static final int SCROLL = 1024;
    public static final int COLLECT_WIDGETS = 2048;
    public static final int DRAGGABLE = 4096;
    public static final int DRAG = 8192;
    public static final int DEBUG = 16384;

    public void apply(IViewportStack var1, int var2);

    public void unapply(IViewportStack var1, int var2);

    public void getWidgetsAt(Stack<IViewport> var1, IWidgetList var2, int var3, int var4);

    default public void getWidgetsBeforeApply(Stack<IViewport> viewports, IWidgetList widgets, int x, int y) {
    }

    default public void preDraw(GuiContext context, boolean transformed) {
    }

    default public void postDraw(GuiContext context, boolean transformed) {
    }

    public static void getChildrenAt(IWidget parent, Stack<IViewport> viewports, IWidgetList widgetList, int x, int y) {
        int currentX = parent.getContext().localX(x);
        int currentY = parent.getContext().localY(y);
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)((Object)child);
                viewport.getWidgetsBeforeApply(viewports, widgetList, x, y);
                viewports.push(viewport);
                viewport.apply(parent.getContext(), 2048);
                viewport.getWidgetsAt(viewports, widgetList, x, y);
                viewport.unapply(parent.getContext(), 2048);
                viewports.pop();
                continue;
            }
            if (child.getArea().isInside(currentX, currentY)) {
                widgetList.add(child, viewports);
            }
            if (!child.hasChildren()) continue;
            IViewport.getChildrenAt(child, viewports, widgetList, x, y);
        }
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> predicate, int context) {
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)((Object)child);
                viewport.apply(parent.getContext(), context);
                if (!predicate.test(child)) {
                    viewport.unapply(parent.getContext(), context);
                    return false;
                }
                if (child.hasChildren() && !IViewport.foreachChild(child, predicate, context)) {
                    viewport.unapply(parent.getContext(), context);
                    return false;
                }
                viewport.unapply(parent.getContext(), context);
                continue;
            }
            if (!predicate.test(child)) {
                return false;
            }
            if (!child.hasChildren() || IViewport.foreachChild(child, predicate, context)) continue;
            return false;
        }
        return true;
    }
}

