/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.sync;

import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.network.packets.PacketSyncHandler;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import com.cleanroommc.modularui.sync.MapKey;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class SyncHandler {
    private GuiSyncHandler syncHandler;
    private MapKey key;

    @ApiStatus.OverrideOnly
    @MustBeInvokedByOverriders
    public void init(MapKey key, GuiSyncHandler syncHandler) {
        this.key = key;
        this.syncHandler = syncHandler;
    }

    public final void syncToClient(int id, Consumer<PacketBuffer> bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150787_b(id);
        bufferConsumer.accept(buffer);
        SyncHandler.sendToClient(buffer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public final void syncToServer(int id, Consumer<PacketBuffer> bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150787_b(id);
        bufferConsumer.accept(buffer);
        SyncHandler.sendToServer(buffer, this);
    }

    public final void sync(int id, Consumer<PacketBuffer> bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150787_b(id);
        bufferConsumer.accept(buffer);
        if (NetworkUtils.isClient(this.getSyncHandler().getPlayer())) {
            SyncHandler.sendToServer(buffer, this);
        } else {
            SyncHandler.sendToClient(buffer, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public abstract void readOnClient(int var1, PacketBuffer var2) throws IOException;

    @ApiStatus.OverrideOnly
    public abstract void readOnServer(int var1, PacketBuffer var2) throws IOException;

    public void detectAndSendChanges(boolean init) {
    }

    public final MapKey getKey() {
        return this.key;
    }

    public final boolean isValid() {
        return this.key != null;
    }

    public GuiSyncHandler getSyncHandler() {
        if (!this.isValid()) {
            throw new IllegalStateException("Sync handler is not yet initialised!");
        }
        return this.syncHandler;
    }

    public static void sendToClient(PacketBuffer buffer, SyncHandler syncHandler) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(syncHandler);
        if (!syncHandler.isValid()) {
            throw new IllegalStateException();
        }
        NetworkHandler.sendToPlayer(new PacketSyncHandler(syncHandler.getKey(), buffer), (EntityPlayerMP)syncHandler.syncHandler.getPlayer());
    }

    public static void sendToServer(PacketBuffer buffer, SyncHandler syncHandler) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(syncHandler);
        if (!syncHandler.isValid()) {
            throw new IllegalStateException();
        }
        NetworkHandler.sendToServer(new PacketSyncHandler(syncHandler.getKey(), buffer));
    }
}

