/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widget.sizer.IResizeable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWidget
extends IGuiElement {
    public void initialise(@NotNull IWidget var1);

    public void dispose();

    public boolean isValid();

    public void drawBackground(GuiContext var1);

    @Override
    public void draw(GuiContext var1);

    public void drawForeground(GuiContext var1);

    default public WidgetTheme getWidgetTheme(ITheme theme) {
        return theme.getFallback();
    }

    public void onFrameUpdate();

    @Override
    public Area getArea();

    @NotNull
    default public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    default public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @NotNull
    public ModularPanel getPanel();

    @Override
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean canBeSeen();

    default public boolean canHover() {
        return true;
    }

    public void markDirty();

    @Override
    @NotNull
    public IWidget getParent();

    public GuiContext getContext();

    public Flex flex();

    @Nullable
    public IResizeable resizer();

    public void resizer(IResizeable var1);

    @Override
    default public void resize() {
        IResizeable resizer = this.resizer();
        if (resizer != null) {
            if (resizer.isSkip()) {
                return;
            }
            resizer.apply(this);
        }
        if (this.hasChildren()) {
            this.getChildren().forEach(IWidget::resize);
        }
        if (this instanceof ILayoutWidget) {
            ((ILayoutWidget)((Object)this)).layoutWidgets();
        }
        if (resizer != null) {
            resizer.postApply(this);
        }
        if (this instanceof ILayoutWidget) {
            ((ILayoutWidget)((Object)this)).postLayoutWidgets();
        }
    }

    default public void postResize() {
    }

    public Flex getFlex();

    default public boolean isExpanded() {
        Flex flex = this.getFlex();
        return flex != null && flex.isExpanded();
    }
}

