/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class AdaptableUITexture
extends UITexture {
    private final int imageWidth;
    private final int imageHeight;
    private final int borderX;
    private final int borderY;

    public AdaptableUITexture(ResourceLocation location, float u0, float v0, float u1, float v1, boolean background, int imageWidth, int imageHeight, int borderX, int borderY) {
        super(location, u0, v0, u1, v1, background);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.borderX = borderX;
        this.borderY = borderY;
    }

    @Override
    public AdaptableUITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new AdaptableUITexture(this.location, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd), this.canApplyTheme, this.imageWidth, this.imageHeight, this.borderX, this.borderY);
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height) {
        if (width == this.imageWidth && height == this.imageHeight) {
            super.draw(context, x, y, width, height);
            return;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        float uB = (float)this.borderX * 1.0f / (float)this.imageWidth;
        float vB = (float)this.borderY * 1.0f / (float)this.imageHeight;
        int x1 = x + width;
        int y1 = y + height;
        if (!(this.borderX > 0 && this.borderY <= 0 || this.borderX <= 0 && this.borderY > 0)) {
            GuiDraw.drawBillboard(x, y, x + this.borderX, y + this.borderY, this.u0, this.v0, this.u0 + uB, this.v0 + vB);
            GuiDraw.drawBillboard(x1 - this.borderX, y, x1, y + this.borderY, this.u1 - uB, this.v0, this.u1, vB);
            GuiDraw.drawBillboard(x, y1 - this.borderY, x + this.borderX, y1, this.u0, this.v1 - vB, uB, this.v1);
            GuiDraw.drawBillboard(x1 - this.borderX, y1 - this.borderY, x1, y1, this.u1 - uB, this.v1 - vB, this.u1, this.v1);
            GuiDraw.drawBillboard(x, y + this.borderY, x + this.borderX, y1 - this.borderY, this.u0, vB, uB, this.v1 - vB);
            GuiDraw.drawBillboard(x + this.borderX, y, x1 - this.borderX, y + this.borderY, uB, this.v0, this.u1 - uB, vB);
            GuiDraw.drawBillboard(x1 - this.borderX, y + this.borderY, x1, y1 - this.borderY, this.u1 - uB, vB, this.u1, this.v1 - vB);
            GuiDraw.drawBillboard(x + this.borderX, y1 - this.borderY, x1 - this.borderX, y1, uB, this.v1 - vB, this.u1 - uB, this.v1);
            GuiDraw.drawBillboard(x + this.borderX, y + this.borderY, x1 - this.borderX, y1 - this.borderY, uB, vB, this.u1 - uB, this.v1 - vB);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }
}

