/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.Circle;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public class DrawableSerialization
implements JsonSerializer<IDrawable>,
JsonDeserializer<IDrawable> {
    private static final Map<String, Function<JsonObject, IDrawable>> DRAWABLE_TYPES = new Object2ObjectOpenHashMap();

    public static void registerDrawableType(String id, Function<JsonObject, IDrawable> creator) {
        if (DRAWABLE_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Drawable type '" + id + "' already exists!");
        }
        DRAWABLE_TYPES.put(id, creator);
    }

    @ApiStatus.Internal
    public static void init() {
        DrawableSerialization.registerDrawableType("texture", UITexture::parseFromJson);
        DrawableSerialization.registerDrawableType("color", json -> new Rectangle());
        DrawableSerialization.registerDrawableType("rectangle", json -> new Rectangle());
        DrawableSerialization.registerDrawableType("ellipse", json -> new Circle());
        DrawableSerialization.registerDrawableType("text", json -> DrawableSerialization.parseKeyFromJson(json, IKey::str));
        DrawableSerialization.registerDrawableType("text:lang", json -> DrawableSerialization.parseKeyFromJson(json, IKey::lang));
    }

    public IDrawable deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!element.isJsonObject()) {
            throw new JsonParseException("Drawable json should be an object.");
        }
        JsonObject json = element.getAsJsonObject();
        String type = JsonHelper.getString(json, "empty", "type");
        if (!DRAWABLE_TYPES.containsKey(type)) {
            throw new JsonParseException("Drawable type '" + type + "' is either not specified or invalid!");
        }
        IDrawable drawable = DRAWABLE_TYPES.get(type).apply(json);
        drawable.loadFromJson(json);
        return drawable;
    }

    public JsonElement serialize(IDrawable src, Type typeOfSrc, JsonSerializationContext context) {
        throw new UnsupportedOperationException();
    }

    private static IKey parseKeyFromJson(JsonObject json, Function<String, IKey> keyFunction) {
        return keyFunction.apply(JsonHelper.getString(json, "No text found!", "text", "string", "key"));
    }
}

