/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class GuiDraw {
    private static final Stack<Area> scissors = new Stack();

    public static void scissor(Area area, GuiContext context) {
        GuiDraw.scissor(area.x, area.y, area.width, area.height, context);
    }

    public static void scissor(int x, int y, int w, int h, GuiContext context) {
        GuiDraw.scissor(context.globalX(x), context.globalY(y), w, h, context.screen.getViewport().width, context.screen.getViewport().height);
    }

    public static void scissorTransformed(int x, int y, int w, int h, GuiContext context) {
        GuiDraw.scissor(x, y, w, h, context.screen.getViewport().width, context.screen.getViewport().height);
    }

    public static void scissor(int x, int y, int w, int h, int sw, int sh) {
        Area scissor;
        Area area = scissor = scissors.isEmpty() ? null : scissors.peek();
        if (scissor != null) {
            w += Math.min(x - scissor.x, 0);
            h += Math.min(y - scissor.y, 0);
            x = MathUtils.clamp(x, scissor.x, scissor.ex());
            y = MathUtils.clamp(y, scissor.y, scissor.ey());
            w = MathUtils.clamp(w, 0, scissor.ex() - x);
            h = MathUtils.clamp(h, 0, scissor.ey() - y);
        }
        scissor = new Area(x, y, w, h);
        GuiDraw.scissorArea(x, y, w, h, sw, sh);
        scissors.add(scissor);
    }

    private static void scissorArea(int x, int y, int w, int h, int sw, int sh) {
        Minecraft mc = Minecraft.func_71410_x();
        float rx = (float)Math.ceil((double)mc.field_71443_c / (double)sw);
        float ry = (float)Math.ceil((double)mc.field_71440_d / (double)sh);
        int xx = (int)((float)x * rx);
        int yy = (int)((float)mc.field_71440_d - (float)(y + h) * ry);
        int ww = (int)((float)w * rx);
        int hh = (int)((float)h * ry);
        GL11.glEnable((int)3089);
        if (ww == 0 || hh == 0) {
            GL11.glScissor((int)0, (int)0, (int)1, (int)1);
        } else {
            GL11.glScissor((int)xx, (int)yy, (int)ww, (int)hh);
        }
    }

    public static void unscissor(GuiContext context) {
        GuiDraw.unscissor(context.screen.getViewport().width, context.screen.getViewport().height);
    }

    public static void unscissor(int sw, int sh) {
        scissors.pop();
        if (scissors.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            Area area = scissors.peek();
            GuiDraw.scissorArea(area.x, area.y, area.width, area.height, sw, sh);
        }
    }

    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiDraw.drawHorizontalGradientRect(left, top, right, bottom, startColor, endColor, 0.0f);
    }

    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float a1 = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(startColor & 0xFF) / 255.0f;
        float a2 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawVerticalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiDraw.drawVerticalGradientRect(left, top, right, bottom, startColor, endColor, 0.0f);
    }

    public static void drawVerticalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float a1 = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(startColor & 0xFF) / 255.0f;
        float a2 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH) {
        GuiDraw.drawBillboard(x, y, u, v, w, h, textureW, textureH, 0.0f);
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH, float z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiDraw.drawBillboard(buffer, x, y, u, v, w, h, textureW, textureH, z);
        tessellator.func_78381_a();
    }

    public static void drawBillboard(BufferBuilder buffer, int x, int y, int u, int v, int w, int h, int textureW, int textureH, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)((float)u * tw), (double)((float)(v + h) * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)((float)(u + w) * tw), (double)((float)(v + h) * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)((float)(u + w) * tw), (double)((float)v * th)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)u * tw), (double)((float)v * th)).func_181675_d();
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH, int tu, int tv) {
        GuiDraw.drawBillboard(x, y, u, v, w, h, textureW, textureH, tu, tv, 0.0f);
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH, int tu, int tv, float z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiDraw.drawBillboard(buffer, x, y, u, v, w, h, textureW, textureH, tu, tv, z);
        tessellator.func_78381_a();
    }

    public static void drawBillboard(BufferBuilder buffer, int x, int y, int u, int v, int w, int h, int textureW, int textureH, int tu, int tv, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)((float)u * tw), (double)((float)tv * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)((float)tu * tw), (double)((float)tv * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)((float)tu * tw), (double)((float)v * th)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)u * tw), (double)((float)v * th)).func_181675_d();
    }

    public static void drawBillboard(int x0, int y0, int x1, int y1, float u0, float v0, float u1, float v1) {
        GuiDraw.drawBillboard(x0, y0, x1, y1, u0, v0, u1, v1, 0.0f);
    }

    public static void drawBillboard(int x0, int y0, int x1, int y1, float u0, float v0, float u1, float v1, float z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiDraw.drawBillboard(buffer, x0, y0, x1, y1, u0, v0, u1, v1, z);
        tessellator.func_78381_a();
    }

    public static void drawBillboard(BufferBuilder buffer, int x0, int y0, int x1, int y1, float u0, float v0, float u1, float v1, float z) {
        buffer.func_181662_b((double)x0, (double)y1, (double)z).func_187315_a((double)u0, (double)v1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)z).func_187315_a((double)u1, (double)v1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y0, (double)z).func_187315_a((double)u1, (double)v0).func_181675_d();
        buffer.func_181662_b((double)x0, (double)y0, (double)z).func_187315_a((double)u0, (double)v0).func_181675_d();
    }

    public static int drawBorder(Area area, int color) {
        return 1;
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color) {
        GuiDraw.drawOutlineCenter(x, y, offset, color, 1);
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color, int border) {
        GuiDraw.drawOutline(x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color) {
        GuiDraw.drawOutline(left, top, right, bottom, color, 1);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color, int border) {
        Gui.func_73734_a((int)left, (int)top, (int)(left + border), (int)bottom, (int)color);
        Gui.func_73734_a((int)(right - border), (int)top, (int)right, (int)bottom, (int)color);
        Gui.func_73734_a((int)(left + border), (int)top, (int)(right - border), (int)(top + border), (int)color);
        Gui.func_73734_a((int)(left + border), (int)(bottom - border), (int)(right - border), (int)bottom, (int)color);
    }

    public static void drawLockedArea(IWidget element) {
        GuiDraw.drawLockedArea(element, 0);
    }

    public static void drawLockedArea(IWidget element, int padding) {
        if (!element.isEnabled()) {
            // empty if block
        }
    }

    public static void drawDropShadow(int left, int top, int right, int bottom, int offset, int opaque, int shadow) {
        left -= offset;
        top -= offset;
        right += offset;
        bottom += offset;
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int segments, int opaque, int shadow) {
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(a) * (double)radius, (double)y + Math.sin(a) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        int i;
        if (offset >= radius) {
            GuiDraw.drawDropCircleShadow(x, y, radius, segments, opaque, shadow);
            return;
        }
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        for (i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(a) * (double)offset, (double)y + Math.sin(a) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (i = 0; i < segments; ++i) {
            double alpha1 = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            double alpha2 = (double)(i + 1) / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(alpha2) * (double)offset, (double)y + Math.sin(alpha2) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha1) * (double)offset, (double)y + Math.sin(alpha1) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha1) * (double)radius, (double)y + Math.sin(alpha1) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha2) * (double)radius, (double)y + Math.sin(alpha2) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width) {
        return GuiDraw.drawMultiText(font, text, x, y, color, width, 12);
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width, int lineHeight) {
        return GuiDraw.drawMultiText(font, text, x, y, color, width, lineHeight, 0.0f, 0.0f);
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width, int lineHeight, float ax, float ay) {
        List list = font.func_78271_c(text, width);
        int h = lineHeight * (list.size() - 1) + font.field_78288_b;
        y = (int)((float)y - (float)h * ay);
        for (String string : list) {
            font.func_175063_a(string, (float)x + (float)(width - font.func_78256_a(string)) * ax, (float)y, color);
            y += lineHeight;
        }
        return h;
    }

    public static void drawTextBackground(FontRenderer font, String text, int x, int y, int color, int background) {
        GuiDraw.drawTextBackground(font, text, x, y, color, background, 3);
    }

    public static void drawTextBackground(FontRenderer font, String text, int x, int y, int color, int background, int offset) {
        GuiDraw.drawTextBackground(font, text, x, y, color, background, offset, true);
    }

    public static void drawTextBackground(FontRenderer font, String text, int x, int y, int color, int background, int offset, boolean shadow) {
        int a = background >> 24 & 0xFF;
        if (a != 0) {
            Gui.func_73734_a((int)(x - offset), (int)(y - offset), (int)(x + font.func_78256_a(text) + offset), (int)(y + font.field_78288_b + offset), (int)background);
        }
        font.func_175065_a(text, (float)x, (float)y, color, shadow);
    }

    public static void drawRepeatBillboard(int x, int y, int w, int h, int u, int v, int tileW, int tileH, int tw, int th) {
        int countX = (w - 1) / tileW + 1;
        int countY = (h - 1) / tileH + 1;
        int fillerX = w - (countX - 1) * tileW;
        int fillerY = h - (countY - 1) * tileH;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            int xx = x + ix * tileW;
            int yy = y + iy * tileH;
            int xw = ix == countX - 1 ? fillerX : tileW;
            int yh = iy == countY - 1 ? fillerY : tileH;
            GuiDraw.drawBillboard(buffer, xx, yy, u, v, xw, yh, tw, th, 0.0f);
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(float x, float y, float width, float height, int color, float border) {
        GuiDraw.drawSolidRect(x - border, y - border, width + 2.0f * border, border, color);
        GuiDraw.drawSolidRect(x - border, y + height, width + 2.0f * border, border, color);
        GuiDraw.drawSolidRect(x - border, y, border, height, color);
        GuiDraw.drawSolidRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSolidRect(float x, float y, float width, float height, int color) {
        GuiDraw.drawRect(x, y, x + width, y + height, color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        float sf = 1.0f / scale;
        fontRenderer.func_175065_a(text, x * sf, y * sf, color, shadow);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }

    public static void drawRect(float left, float top, float right, float bottom, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawFluidTexture(FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null) {
            return;
        }
        Fluid fluid = content.getFluid();
        ResourceLocation fluidStill = fluid.getStill(content);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        int fluidColor = fluid.getColor(content);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        float u0 = sprite.func_94209_e();
        float u1 = sprite.func_94212_f();
        float v0 = sprite.func_94206_g();
        float v1 = sprite.func_94210_h();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float r = Color.getRedF(fluidColor);
        float g = Color.getGreenF(fluidColor);
        float b = Color.getBlueF(fluidColor);
        float a = Color.getAlphaF(fluidColor);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)x0, (double)y1, (double)z).func_187315_a((double)u0, (double)v1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)z).func_187315_a((double)u1, (double)v1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y0, (double)z).func_187315_a((double)u1, (double)v0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x0, (double)y0, (double)z).func_187315_a((double)u0, (double)v0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawGradientRect(float zLevel, float left, float top, float right, float bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawHoveringText(GuiContext context, List<IKey> textLines, int maxWidth, float scale, boolean forceShadow, Alignment alignment) {
        if (textLines.isEmpty()) {
            return;
        }
        List<String> lines = textLines.stream().map(IKey::get).collect(Collectors.toList());
        GuiDraw.drawHoveringTextFormatted(context, lines, maxWidth, scale, forceShadow, alignment);
    }

    public static void drawHoveringTextFormatted(GuiContext context, List<String> lines, int maxWidth) {
        GuiDraw.drawHoveringTextFormatted(context, lines, maxWidth, 1.0f, false, Alignment.TopLeft);
    }

    public static void drawTooltip(GuiContext context, List<IDrawable> lines, int maxWidth, float scale, boolean forceShadow, Alignment alignment) {
    }

    public static void drawHoveringTextFormatted(GuiContext context, List<String> lines, int maxWidth, float scale, boolean forceShadow, Alignment alignment) {
        int mouseY;
        if (lines.isEmpty()) {
            return;
        }
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Area screen = context.screen.getViewport();
        int mouseX = context.getMouseX();
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(ItemStack.field_190927_a, lines, mouseX, mouseY = context.getMouseY(), screen.width, screen.height, maxWidth, TextRenderer.getFontRenderer());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        lines = event.getLines();
        mouseX = event.getX();
        mouseY = event.getY();
        int screenWidth = event.getScreenWidth();
        int screenHeight = event.getScreenHeight();
        int maxTextWidth = maxWidth = event.getMaxWidth();
        boolean mouseOnRightSide = false;
        int screenSpaceRight = screenWidth - mouseX - 16;
        if ((float)mouseX > (float)screenWidth / 2.0f) {
            mouseOnRightSide = true;
        }
        if (maxTextWidth > screenSpaceRight) {
            maxTextWidth = screenSpaceRight;
        }
        boolean putOnLeft = false;
        int tooltipY = mouseY - 12;
        int tooltipX = mouseX + 12;
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setPos(mouseX, mouseY);
        renderer.setAlignment(Alignment.TopLeft, maxTextWidth);
        renderer.setScale(scale);
        renderer.setShadow(forceShadow);
        renderer.setSimulate(true);
        List<Pair<String, Float>> measuredLines = renderer.measureLines(lines);
        if (mouseOnRightSide && measuredLines.size() > lines.size()) {
            putOnLeft = true;
            maxTextWidth = Math.min(maxWidth, mouseX - 16);
        }
        renderer.setAlignment(Alignment.TopLeft, maxTextWidth);
        measuredLines = renderer.measureLines(lines);
        renderer.drawMeasuredLines(measuredLines);
        int tooltipTextWidth = (int)renderer.lastWidth;
        int tooltipHeight = (int)renderer.lastHeight;
        if (mouseOnRightSide && putOnLeft) {
            tooltipX += -24 - tooltipTextWidth;
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int color = 0xFFFFFF;
        GuiDraw.drawTooltipBackground(lines, tooltipX, tooltipY, tooltipTextWidth, tooltipHeight, 300);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(ItemStack.field_190927_a, lines, tooltipX, tooltipY, TextRenderer.getFontRenderer(), tooltipTextWidth, tooltipHeight));
        renderer.setSimulate(false);
        renderer.setPos(tooltipX, tooltipY);
        renderer.setAlignment(alignment, maxTextWidth);
        renderer.setColor(color);
        renderer.drawMeasuredLines(measuredLines);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(ItemStack.field_190927_a, lines, tooltipX, tooltipY, TextRenderer.getFontRenderer(), tooltipTextWidth, tooltipHeight));
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    public static void drawTooltipBackground(List<String> lines, int x, int y, int textWidth, int height, int z) {
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(ItemStack.field_190927_a, lines, x, y, TextRenderer.getFontRenderer(), backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiDraw.drawGradientRect(z, x - 3, y - 4, x + textWidth + 3, y - 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRect(z, x - 3, y + height + 3, x + textWidth + 3, y + height + 4, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRect(z, x - 3, y - 3, x + textWidth + 3, y + height + 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRect(z, x - 4, y - 3, x - 3, y + height + 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRect(z, x + textWidth + 3, y - 3, x + textWidth + 4, y + height + 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRect(z, x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, borderColorStart, borderColorEnd);
        GuiDraw.drawGradientRect(z, x + textWidth + 2, y - 3 + 1, x + textWidth + 3, y + height + 3 - 1, borderColorStart, borderColorEnd);
        GuiDraw.drawGradientRect(z, x - 3, y - 3, x + textWidth + 3, y - 3 + 1, borderColorStart, borderColorStart);
        GuiDraw.drawGradientRect(z, x - 3, y + height + 2, x + textWidth + 3, y + height + 3, borderColorEnd, borderColorEnd);
    }
}

