/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.drawable.TabTexture;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuiTextures {
    private static final Map<String, UITexture> ALL = new Object2ObjectOpenHashMap();
    private static final Map<String, UITexture> ICONS = new Object2ObjectOpenHashMap();
    private static final Map<String, UITexture> BACKGROUNDS = new Object2ObjectOpenHashMap();
    public static final ResourceLocation ICONS_LOCATION = new ResourceLocation("modularui", "textures/gui/icons.png");
    public static final UITexture GEAR = GuiTextures.icon("gear", 0, 0);
    public static final UITexture MORE = GuiTextures.icon("more", 16, 0);
    public static final UITexture SAVED = GuiTextures.icon("saved", 32, 0);
    public static final UITexture SAVE = GuiTextures.icon("save", 48, 0);
    public static final UITexture ADD = GuiTextures.icon("add", 64, 0);
    public static final UITexture DUPE = GuiTextures.icon("dupe", 80, 0);
    public static final UITexture REMOVE = GuiTextures.icon("remove", 96, 0);
    public static final UITexture POSE = GuiTextures.icon("pose", 112, 0);
    public static final UITexture FILTER = GuiTextures.icon("filter", 128, 0);
    public static final UITexture MOVE_UP = GuiTextures.icon("move_up", 144, 0, 16, 8);
    public static final UITexture MOVE_DOWN = GuiTextures.icon("move_down", 144, 8, 16, 8);
    public static final UITexture LOCKED = GuiTextures.icon("locked", 160, 0);
    public static final UITexture UNLOCKED = GuiTextures.icon("unlocked", 176, 0);
    public static final UITexture COPY = GuiTextures.icon("copy", 192, 0);
    public static final UITexture PASTE = GuiTextures.icon("paste", 208, 0);
    public static final UITexture CUT = GuiTextures.icon("cut", 224, 0);
    public static final UITexture REFRESH = GuiTextures.icon("refresh", 240, 0);
    public static final UITexture DOWNLOAD = GuiTextures.icon("download", 0, 16);
    public static final UITexture UPLOAD = GuiTextures.icon("upload", 16, 16);
    public static final UITexture SERVER = GuiTextures.icon("server", 32, 16);
    public static final UITexture FOLDER = GuiTextures.icon("folder", 48, 16);
    public static final UITexture IMAGE = GuiTextures.icon("image", 64, 16);
    public static final UITexture EDIT = GuiTextures.icon("edit", 80, 16);
    public static final UITexture MATERIAL = GuiTextures.icon("material", 96, 16);
    public static final UITexture CLOSE = GuiTextures.icon("close", 112, 16);
    public static final UITexture LIMB = GuiTextures.icon("limb", 128, 16);
    public static final UITexture CODE = GuiTextures.icon("code", 144, 16);
    public static final UITexture MOVE_LEFT = GuiTextures.icon("move_left", 144, 16, 8, 16);
    public static final UITexture MOVE_RIGHT = GuiTextures.icon("move_right", 152, 16, 8, 16);
    public static final UITexture HELP = GuiTextures.icon("help", 160, 16);
    public static final UITexture LEFT_HANDLE = GuiTextures.icon("left_handle", 176, 16);
    public static final UITexture MAIN_HANDLE = GuiTextures.icon("main_handle", 192, 16);
    public static final UITexture RIGHT_HANDLE = GuiTextures.icon("right_handle", 208, 16);
    public static final UITexture REVERSE = GuiTextures.icon("reverse", 224, 16);
    public static final UITexture BLOCK = GuiTextures.icon("", 240, 16);
    public static final UITexture FAVORITE = GuiTextures.icon("block", 0, 32);
    public static final UITexture VISIBLE = GuiTextures.icon("visible", 16, 32);
    public static final UITexture INVISIBLE = GuiTextures.icon("invisible", 32, 32);
    public static final UITexture PLAY = GuiTextures.icon("play", 48, 32);
    public static final UITexture PAUSE = GuiTextures.icon("pause", 64, 32);
    public static final UITexture MAXIMIZE = GuiTextures.icon("maximize", 80, 32);
    public static final UITexture MINIMIZE = GuiTextures.icon("minimize", 96, 32);
    public static final UITexture STOP = GuiTextures.icon("stop", 112, 32);
    public static final UITexture FULLSCREEN = GuiTextures.icon("fullscreen", 128, 32);
    public static final UITexture ALL_DIRECTIONS = GuiTextures.icon("all_directions", 144, 32);
    public static final UITexture SPHERE = GuiTextures.icon("sphere", 160, 32);
    public static final UITexture SHIFT_TO = GuiTextures.icon("shift_to", 176, 32);
    public static final UITexture SHIFT_FORWARD = GuiTextures.icon("shift_forward", 192, 32);
    public static final UITexture SHIFT_BACKWARD = GuiTextures.icon("shift_backward", 208, 32);
    public static final UITexture MOVE_TO = GuiTextures.icon("move_to", 224, 32);
    public static final UITexture GRAPH = GuiTextures.icon("graph", 240, 32);
    public static final UITexture WRENCH = GuiTextures.icon("wrench", 0, 48);
    public static final UITexture EXCLAMATION = GuiTextures.icon("exclamation", 16, 48);
    public static final UITexture LEFTLOAD = GuiTextures.icon("leftload", 32, 48);
    public static final UITexture RIGHTLOAD = GuiTextures.icon("rightload", 48, 48);
    public static final UITexture BUBBLE = GuiTextures.icon("bubble", 64, 48);
    public static final UITexture FILE = GuiTextures.icon("file", 80, 48);
    public static final UITexture PROCESSOR = GuiTextures.icon("processor", 96, 48);
    public static final UITexture MAZE = GuiTextures.icon("maze", 112, 48);
    public static final UITexture BOOKMARK = GuiTextures.icon("bookmark", 128, 48);
    public static final UITexture SOUND = GuiTextures.icon("sound", 144, 48);
    public static final UITexture SEARCH = GuiTextures.icon("search", 160, 48);
    public static final UITexture CHECKBOARD = GuiTextures.icon("checkboard", 0, 240);
    public static final UITexture DISABLED = GuiTextures.icon("disabled", 16, 240);
    public static final UITexture CURSOR = GuiTextures.icon("cursor", 32, 240);
    public static final UITexture LOGO = UITexture.builder().location("modularui", "modular_ui_logo").imageSize(603, 603).registerAsIcon("logo").build();
    public static final UITexture BACKGROUND = UITexture.builder().location("modularui", "gui/background/vanilla_background").imageSize(195, 136).adaptable(4).registerAsBackground("vanilla_background").build();
    public static final UITexture DISPLAY = UITexture.builder().location("modularui", "gui/background/display").imageSize(143, 75).adaptable(2).registerAsBackground("display", false).build();
    public static final UITexture DISPLAY_SMALL = UITexture.builder().location("modularui", "gui/background/display_small").imageSize(18, 18).adaptable(1).registerAsBackground("display_small", false).build();
    public static final UITexture BUTTON = UITexture.builder().location("modularui", "gui/widgets/base_button").imageSize(18, 18).adaptable(1).registerAsBackground("vanilla_button").build();
    public static final UITexture SLOT = UITexture.builder().location("modularui", "gui/slot/item").imageSize(18, 18).adaptable(1).registerAsBackground("slot_item").build();
    public static final UITexture SLOT_DARK = UITexture.builder().location("modularui", "gui/slot/fluid").imageSize(18, 18).adaptable(1).registerAsBackground("slot_fluid").build();
    public static final UITexture PROGRESS_ARROW = UITexture.builder().location("modularui", "gui/widgets/progress_bar_arrow").imageSize(20, 40).build();
    public static final UITexture PROGRESS_CYCLE = UITexture.builder().location("modularui", "gui/widgets/progress_bar_mixer").imageSize(20, 40).build();
    public static final UITexture CYCLE_BUTTON_DEMO = UITexture.builder().location("modularui", "gui/widgets/cycle_button_demo").imageSize(18, 54).build();
    public static final UITexture CHECK_BOX = UITexture.fullImage("modularui", "gui/widgets/toggle_config", false);
    public static final TabTexture TAB_TOP = TabTexture.of(UITexture.fullImage("modularui", "gui/tab/tabs_top", true), GuiAxis.Y, false, 28, 32, 4);
    public static final TabTexture TAB_BOTTOM = TabTexture.of(UITexture.fullImage("modularui", "gui/tab/tabs_bottom", true), GuiAxis.Y, true, 28, 32, 4);
    public static final TabTexture TAB_LEFT = TabTexture.of(UITexture.fullImage("modularui", "gui/tab/tabs_left", true), GuiAxis.X, false, 32, 28, 4);
    public static final TabTexture TAB_RIGHT = TabTexture.of(UITexture.fullImage("modularui", "gui/tab/tabs_right", true), GuiAxis.X, true, 32, 28, 4);

    public static void registerIcon(String key, UITexture texture) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(texture);
        if (ALL.containsKey(key)) {
            throw new IllegalStateException();
        }
        ICONS.put(key, texture);
        ALL.put(key, texture);
    }

    public static void registerBackground(String key, UITexture texture) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(texture);
        if (ALL.containsKey(key)) {
            throw new IllegalStateException();
        }
        BACKGROUNDS.put(key, texture);
        ALL.put(key, texture);
    }

    @Nullable
    public static UITexture get(String key) {
        return ALL.get(key);
    }

    @Nullable
    public static UITexture getIcon(String key) {
        return ICONS.get(key);
    }

    @Nullable
    public static UITexture getBackground(String key) {
        return BACKGROUNDS.get(key);
    }

    private static UITexture icon(String name, int x, int y, int w, int h) {
        return UITexture.builder().location(ICONS_LOCATION).imageSize(256, 256).uv(x, y, w, h).registerAsIcon(name).build();
    }

    private static UITexture icon(String name, int x, int y) {
        return GuiTextures.icon(name, x, y, 16, 16);
    }
}

