/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;

public class Icon
implements IIcon {
    private final IDrawable drawable;
    private int width = 18;
    private int height = 18;
    private Alignment alignment = Alignment.Center;

    public Icon(IDrawable drawable) {
        this.drawable = drawable;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public Icon width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public int getHeight() {
        return this.height + 1;
    }

    public Icon height(int height) {
        this.height = height;
        return this;
    }

    public Icon size(int width, int height) {
        return this.width(width).height(height);
    }

    public Icon size(int size) {
        return this.width(size).height(size);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Icon alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height) {
        if (this.width > 0) {
            x = (int)((float)x + ((float)width * this.alignment.x - (float)this.width * this.alignment.x));
            width = this.width;
        }
        if (this.height > 0) {
            y = (int)((float)y + ((float)height * this.alignment.y - (float)this.height * this.alignment.y));
            height = this.height;
        }
        this.drawable.draw(context, x, y, width, height);
    }
}

