/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class Rectangle
implements IDrawable {
    public static final double PI_2 = 1.5707963267948966;
    private int cornerRadius = 0;
    private int colorTL = 0;
    private int colorTR = 0;
    private int colorBL = 0;
    private int colorBR = 0;
    private int cornerSegments = 6;
    private boolean canApplyTheme = false;

    public int getColor() {
        return this.colorTL;
    }

    public Rectangle setCornerRadius(int cornerRadius) {
        this.cornerRadius = Math.max(0, cornerRadius);
        return this;
    }

    public Rectangle setColor(int colorTL, int colorTR, int colorBL, int colorBR) {
        this.colorTL = colorTL;
        this.colorTR = colorTR;
        this.colorBL = colorBL;
        this.colorBR = colorBR;
        return this;
    }

    public Rectangle setVerticalGradient(int colorTop, int colorBottom) {
        return this.setColor(colorTop, colorTop, colorBottom, colorBottom);
    }

    public Rectangle setHorizontalGradient(int colorLeft, int colorRight) {
        return this.setColor(colorLeft, colorRight, colorLeft, colorRight);
    }

    public Rectangle setColor(int color) {
        return this.setColor(color, color, color, color);
    }

    public Rectangle setCornerSegments(int cornerSegments) {
        this.cornerSegments = cornerSegments;
        return this;
    }

    public void setCanApplyTheme(boolean canApplyTheme) {
        this.canApplyTheme = canApplyTheme;
    }

    @Override
    public void applyThemeColor(ITheme theme, WidgetTheme widgetTheme) {
        if (this.canApplyTheme()) {
            Color.setGlColor(widgetTheme.getColor());
        } else {
            Color.setGlColorOpaque(Color.WHITE.normal);
        }
    }

    @Override
    public void draw(GuiContext context, int x0, int y0, int width, int height) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float x1 = x0 + width;
        float y1 = y0 + height;
        if (this.cornerRadius == 0) {
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((double)x0, (double)y0, 0.0).func_181669_b(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL)).func_181675_d();
            bufferbuilder.func_181662_b((double)x0, (double)y1, 0.0).func_181669_b(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL)).func_181675_d();
            bufferbuilder.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR)).func_181675_d();
            bufferbuilder.func_181662_b((double)x1, (double)y0, 0.0).func_181669_b(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR)).func_181675_d();
        } else {
            float y;
            float x;
            int i;
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            int color = Color.average(this.colorBL, this.colorBR, this.colorTR, this.colorTL);
            bufferbuilder.func_181662_b((double)((float)x0 + (float)width / 2.0f), (double)((float)y0 + (float)height / 2.0f), 0.0).func_181669_b(Color.getRed(color), Color.getGreen(color), Color.getBlue(color), Color.getAlpha(color)).func_181675_d();
            bufferbuilder.func_181662_b((double)x0, (double)(y0 + this.cornerRadius), 0.0).func_181669_b(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL)).func_181675_d();
            bufferbuilder.func_181662_b((double)x0, (double)(y1 - (float)this.cornerRadius), 0.0).func_181669_b(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL)).func_181675_d();
            int n = this.cornerSegments;
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x0 + this.cornerRadius) - Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y1 - (float)this.cornerRadius) + Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(Color.getRed(this.colorBL), Color.getGreen(this.colorBL), Color.getBlue(this.colorBL), Color.getAlpha(this.colorBL)).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)(x1 - (float)this.cornerRadius), (double)y1, 0.0).func_181669_b(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR)).func_181675_d();
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x1 - (float)this.cornerRadius) + Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y1 - (float)this.cornerRadius) + Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(Color.getRed(this.colorBR), Color.getGreen(this.colorBR), Color.getBlue(this.colorBR), Color.getAlpha(this.colorBR)).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)x1, (double)(y0 + this.cornerRadius), 0.0).func_181669_b(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR)).func_181675_d();
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x1 - (float)this.cornerRadius) + Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y0 + this.cornerRadius) - Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(Color.getRed(this.colorTR), Color.getGreen(this.colorTR), Color.getBlue(this.colorTR), Color.getAlpha(this.colorTR)).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)(x0 + this.cornerRadius), (double)y0, 0.0).func_181669_b(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL)).func_181675_d();
            for (i = 1; i <= n; ++i) {
                x = (float)((double)(x0 + this.cornerRadius) - Math.sin(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                y = (float)((double)(y0 + this.cornerRadius) - Math.cos(1.5707963267948966 / (double)n * (double)i) * (double)this.cornerRadius);
                bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL)).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)x0, (double)(y0 + this.cornerRadius), 0.0).func_181669_b(Color.getRed(this.colorTL), Color.getGreen(this.colorTL), Color.getBlue(this.colorTL), Color.getAlpha(this.colorTL)).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @Override
    public boolean canApplyTheme() {
        return this.canApplyTheme;
    }
}

