/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.utils.Alignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TextRenderer {
    public static final TextRenderer SHARED = new TextRenderer();
    protected float maxWidth = -1.0f;
    protected float maxHeight = -1.0f;
    protected int x = 0;
    protected int y = 0;
    protected Alignment alignment = Alignment.TopLeft;
    protected float scale = 1.0f;
    protected boolean shadow = false;
    protected int color = 0;
    protected boolean simulate;
    protected float lastWidth = 0.0f;
    protected float lastHeight = 0.0f;

    public void setAlignment(Alignment alignment, float maxWidth) {
        this.setAlignment(alignment, maxWidth, -1.0f);
    }

    public void setAlignment(Alignment alignment, float maxWidth, float maxHeight) {
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void draw(String text) {
        if (this.maxWidth <= 0.0f && !text.contains("\n'")) {
            this.drawSimple(text);
        } else {
            this.draw(Collections.singletonList(text));
        }
    }

    public void draw(List<String> lines) {
        this.drawMeasuredLines(this.measureLines(lines));
    }

    protected void drawMeasuredLines(List<Pair<String, Float>> measuredLines) {
        float maxW = 0.0f;
        int y0 = this.getStartY(measuredLines.size());
        for (Pair<String, Float> measuredLine : measuredLines) {
            int x0 = this.getStartX(((Float)measuredLine.getRight()).floatValue());
            maxW = Math.max(this.draw((String)measuredLine.getLeft(), x0, y0), maxW);
            y0 = (int)((float)y0 + this.getFontHeight());
        }
        this.lastWidth = this.maxWidth > 0.0f ? Math.min(maxW, this.maxWidth) : maxW;
        this.lastHeight = (float)measuredLines.size() * this.getFontHeight();
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public void drawSimple(String text) {
        float w = TextRenderer.getFontRenderer().func_78256_a(text);
        int y = this.getStartY(1);
        int x = this.getStartX(w);
        this.draw(text, x, y);
        this.lastWidth = w;
        this.lastHeight = this.getFontHeight();
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public List<Pair<String, Float>> measureLines(List<String> lines) {
        ArrayList<Pair<String, Float>> measuredLines = new ArrayList<Pair<String, Float>>();
        for (String line : lines) {
            for (String subLine : this.wrapLine(line)) {
                float width = (float)TextRenderer.getFontRenderer().func_78256_a(subLine) * this.scale;
                measuredLines.add((Pair<String, Float>)Pair.of((Object)subLine, (Object)Float.valueOf(width)));
            }
        }
        return measuredLines;
    }

    public List<String> wrapLine(String line) {
        return this.maxWidth > 0.0f ? TextRenderer.getFontRenderer().func_78271_c(line, (int)(this.maxWidth / this.scale)) : Collections.singletonList(line);
    }

    public boolean wouldFit(List<String> text) {
        if (this.maxHeight > 0.0f && this.maxHeight < (float)text.size() * this.getFontHeight() - this.scale) {
            return false;
        }
        if (this.maxWidth > 0.0f) {
            for (String line : text) {
                if (!(this.maxWidth < (float)TextRenderer.getFontRenderer().func_78256_a(line))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxWidth(List<String> lines) {
        if (lines.isEmpty()) {
            return 0;
        }
        List<Pair<String, Float>> measuredLines = this.measureLines(lines);
        float w = 0.0f;
        for (Pair<String, Float> measuredLine : measuredLines) {
            w = Math.max(w, ((Float)measuredLine.getRight()).floatValue());
        }
        return (int)Math.ceil(w);
    }

    protected int getStartY(int lines) {
        if (this.alignment.y > 0.0f && this.maxHeight > 0.0f) {
            float height = (float)lines * this.getFontHeight() - this.scale;
            return (int)((float)this.y + this.maxHeight * this.alignment.y - height * this.alignment.y);
        }
        return this.y;
    }

    protected int getStartX(float lineWidth) {
        if (this.alignment.x > 0.0f && this.maxWidth > 0.0f) {
            return (int)((float)this.x + this.maxWidth * this.alignment.x - lineWidth * this.alignment.x);
        }
        return this.x;
    }

    protected float draw(String text, float x, float y) {
        if (this.simulate) {
            return TextRenderer.getFontRenderer().func_78256_a(text);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        int width = TextRenderer.getFontRenderer().func_175065_a(text, x / this.scale, y / this.scale, this.color, this.shadow);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        return (float)width * this.scale;
    }

    public float getFontHeight() {
        return (float)TextRenderer.getFontRenderer().field_78288_b * this.scale;
    }

    public float getLastHeight() {
        return this.lastHeight;
    }

    public float getLastWidth() {
        return this.lastWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

