/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.AdaptableUITexture;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class UITexture
implements IDrawable {
    public static final Map<ResourceLocation, UITexture> JSON_TEXTURES = new HashMap<ResourceLocation, UITexture>();
    public static final UITexture DEFAULT = UITexture.fullImage("gui/options_background", true);
    public final ResourceLocation location;
    public final float u0;
    public final float v0;
    public final float u1;
    public final float v1;
    public final boolean canApplyTheme;
    private static int defaultImageWidth = 16;
    private static int defaultImageHeight = 16;

    public UITexture(ResourceLocation location, float u0, float v0, float u1, float v1, boolean canApplyTheme) {
        this.canApplyTheme = canApplyTheme;
        if (!location.func_110623_a().endsWith(".png")) {
            location = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".png");
        }
        if (!location.func_110623_a().startsWith("textures/")) {
            location = new ResourceLocation(location.func_110624_b(), "textures/" + location.func_110623_a());
        }
        this.location = location;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UITexture fullImage(ResourceLocation location, boolean canApplyTheme) {
        return new UITexture(location, 0.0f, 0.0f, 1.0f, 1.0f, canApplyTheme);
    }

    public static UITexture fullImage(String location, boolean canApplyTheme) {
        return UITexture.fullImage(new ResourceLocation(location), canApplyTheme);
    }

    public static UITexture fullImage(String mod, String location, boolean canApplyTheme) {
        return UITexture.fullImage(new ResourceLocation(mod, location), canApplyTheme);
    }

    public UITexture getSubArea(Area bounds) {
        return this.getSubArea(bounds.x, bounds.y, bounds.ex(), bounds.ey());
    }

    public UITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new UITexture(this.location, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd), this.canApplyTheme);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    protected final float calcU(float uNew) {
        return (this.u1 - this.u0) * uNew + this.u0;
    }

    protected final float calcV(float vNew) {
        return (this.v1 - this.v0) * vNew + this.v0;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height) {
        this.draw(x, y, width, height);
    }

    public void draw(float x, float y, float width, float height) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        UITexture.draw(this.location, x, y, width, height, this.u0, this.v0, this.u1, this.v1);
        GlStateManager.func_179084_k();
    }

    public void drawSubArea(float x, float y, float width, float height, float uStart, float vStart, float uEnd, float vEnd) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        UITexture.draw(this.location, x, y, width, height, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd));
        GlStateManager.func_179084_k();
    }

    public static void draw(ResourceLocation location, float x0, float y0, float width, float height, float u0, float v0, float u1, float v1) {
        float x1 = x0 + width;
        float y1 = y0 + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x0, (double)y1, 0.0).func_187315_a((double)u0, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y1, 0.0).func_187315_a((double)u1, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)x1, (double)y0, 0.0).func_187315_a((double)u1, (double)v0).func_181675_d();
        bufferbuilder.func_181662_b((double)x0, (double)y0, 0.0).func_187315_a((double)u0, (double)v0).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void applyThemeColor(ITheme theme, WidgetTheme widgetTheme) {
        if (this.canApplyTheme()) {
            Color.setGlColor(widgetTheme.getColor());
        } else {
            Color.setGlColorOpaque(Color.WHITE.normal);
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.canApplyTheme;
    }

    public static IDrawable parseFromJson(JsonObject json) {
        boolean mode2;
        UITexture drawable;
        String name = JsonHelper.getString(json, null, "name", "id");
        if (name != null && (drawable = GuiTextures.get(name)) != null) {
            return drawable;
        }
        Builder builder = UITexture.builder();
        builder.location(JsonHelper.getString(json, "modularui:gui/widgets/error", "location")).imageSize(JsonHelper.getInt(json, defaultImageWidth, "imageWidth", "iw"), JsonHelper.getInt(json, defaultImageHeight, "imageHeight", "ih"));
        boolean mode1 = json.has("x") || json.has("y") || json.has("w") || json.has("h") || json.has("width") || json.has("height");
        boolean bl = mode2 = json.has("u0") || json.has("v0") || json.has("u1") || json.has("u1");
        if (mode1) {
            if (mode2) {
                throw new JsonParseException("Tried to specify x, y, w, h and u0, v0, u1, v1!");
            }
            builder.uv(JsonHelper.getInt(json, 0, "x"), JsonHelper.getInt(json, 0, "y"), JsonHelper.getInt(json, builder.iw, "w", "width"), JsonHelper.getInt(json, builder.ih, "h", "height"));
        } else if (mode2) {
            builder.uv(JsonHelper.getFloat(json, 0.0f, "u0"), JsonHelper.getFloat(json, 0.0f, "v0"), JsonHelper.getFloat(json, 1.0f, "u1"), JsonHelper.getFloat(json, 1.0f, "v1"));
        }
        int borderX = JsonHelper.getInt(json, 0, "borderX", "border");
        int borderY = JsonHelper.getInt(json, 0, "borderY", "border");
        if (borderX > 0 || borderY > 0) {
            builder.adaptable(borderX, borderY);
        }
        return builder.build();
    }

    public static void setDefaultImageSize(int w, int h) {
        defaultImageWidth = w;
        defaultImageHeight = h;
    }

    static /* synthetic */ int access$200() {
        return defaultImageWidth;
    }

    static /* synthetic */ int access$300() {
        return defaultImageHeight;
    }

    public static enum Type {
        ICON,
        BACKGROUND,
        OTHER;

    }

    public static class Builder {
        private ResourceLocation location;
        private int iw = UITexture.access$200();
        private int ih = UITexture.access$300();
        private int x;
        private int y;
        private int w;
        private int h;
        private float u0 = 0.0f;
        private float v0 = 0.0f;
        private float u1 = 1.0f;
        private float v1 = 1.0f;
        private byte mode = 0;
        private int borderX = 0;
        private int borderY = 0;
        private Type type;
        private String name;
        private boolean canApplyTheme = false;

        public Builder location(ResourceLocation loc) {
            this.location = loc;
            return this;
        }

        public Builder location(String mod, String path) {
            this.location = new ResourceLocation(mod, path);
            return this;
        }

        public Builder location(String path) {
            this.location = new ResourceLocation(path);
            return this;
        }

        public Builder imageSize(int w, int h) {
            this.iw = w;
            this.ih = h;
            return this;
        }

        public Builder fullImage() {
            this.mode = 0;
            return this;
        }

        public Builder uv(int x, int y, int w, int h) {
            this.mode = 1;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder uv(float u0, float v0, float u1, float v1) {
            this.mode = (byte)2;
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public Builder adaptable(int borderX, int borderY) {
            this.borderX = borderX;
            this.borderY = borderY;
            return this;
        }

        public Builder adaptable(int border) {
            return this.adaptable(border, border);
        }

        public Builder canApplyTheme() {
            this.canApplyTheme = true;
            return this;
        }

        public Builder registerAs(Type type, String name) {
            this.type = type;
            this.name = name;
            return this;
        }

        public Builder registerAsIcon(String name) {
            return this.registerAs(Type.ICON, name);
        }

        public Builder registerAsBackground(String name) {
            return this.registerAsBackground(name, true);
        }

        public Builder registerAsBackground(String name, boolean canApplyTheme) {
            if (canApplyTheme) {
                this.canApplyTheme();
            }
            return this.registerAs(Type.BACKGROUND, name);
        }

        public UITexture build() {
            UITexture texture = this.create();
            if (this.type != null && this.name != null) {
                if (this.type == Type.ICON) {
                    GuiTextures.registerIcon(this.name, texture);
                } else if (this.type == Type.BACKGROUND) {
                    GuiTextures.registerBackground(this.name, texture);
                }
            }
            return texture;
        }

        private UITexture create() {
            if (this.location == null) {
                throw new NullPointerException("Location must not be null");
            }
            if (this.iw <= 0 || this.ih <= 0) {
                throw new IllegalArgumentException("Image size must be > 0");
            }
            if (this.mode == 0) {
                this.u0 = 0.0f;
                this.v0 = 0.0f;
                this.u1 = 1.0f;
                this.v1 = 1.0f;
                this.mode = (byte)2;
            } else if (this.mode == 1) {
                float tw = 1.0f / (float)this.iw;
                float th = 1.0f / (float)this.ih;
                this.u0 = (float)this.x * tw;
                this.v0 = (float)this.y * th;
                this.u1 = (float)(this.x + this.w) * tw;
                this.v1 = (float)(this.y + this.h) * th;
                this.mode = (byte)2;
            }
            if (this.mode == 2) {
                if (this.u0 < 0.0f || this.v0 < 0.0f || this.u1 > 1.0f || this.v1 > 1.0f) {
                    throw new IllegalArgumentException("UV values must be 0 - 1");
                }
                if (this.borderX > 0 || this.borderY > 0) {
                    return new AdaptableUITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.canApplyTheme, this.iw, this.ih, this.borderX, this.borderY);
                }
                return new UITexture(this.location, this.u0, this.v0, this.u1, this.v1, this.canApplyTheme);
            }
            throw new IllegalStateException();
        }
    }
}

