/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.manager;

import com.cleanroommc.modularui.manager.GuiCreationContext;
import com.cleanroommc.modularui.manager.GuiManager;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiInfo {
    private static int nextId = 0;
    private final BiConsumer<GuiCreationContext, GuiSyncHandler> serverGuiCreator;
    private final Function<GuiCreationContext, Object> clientGuiCreator;
    private final int id;

    public static Builder builder() {
        return new Builder();
    }

    public GuiInfo(BiConsumer<GuiCreationContext, GuiSyncHandler> serverGuiCreator, Function<GuiCreationContext, Object> clientGuiCreator) {
        this.serverGuiCreator = serverGuiCreator;
        this.clientGuiCreator = clientGuiCreator;
        this.id = nextId++;
        GuiManager.INSTANCE.register(this);
    }

    public int getId() {
        return this.id;
    }

    public void open(EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)"modularui", (int)this.id, (World)player.field_70170_p, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u), (int)((int)player.field_70161_v));
    }

    public void open(EntityPlayer player, World world, BlockPos pos) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)"modularui", (int)this.id, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    public void open(EntityPlayer player, World world, int x, int y, int z) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)"modularui", (int)this.id, (World)world, (int)x, (int)y, (int)z);
    }

    public void createServerGuiManager(GuiCreationContext context, GuiSyncHandler guiSyncHandler) {
        this.serverGuiCreator.accept(context, guiSyncHandler);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen createGuiScreen(GuiCreationContext context) {
        Object screen = this.clientGuiCreator.apply(context);
        if (!(screen instanceof ModularScreen)) {
            throw new IllegalStateException("Client screen must be an instance of ModularScreen");
        }
        return (ModularScreen)screen;
    }

    public static class Builder {
        private BiConsumer<GuiCreationContext, GuiSyncHandler> serverGuiCreator;
        private Function<GuiCreationContext, Object> clientGuiCreator;

        public Builder serverGui(BiConsumer<GuiCreationContext, GuiSyncHandler> serverGuiCreator) {
            this.serverGuiCreator = serverGuiCreator;
            return this;
        }

        public Builder clientGui(Function<GuiCreationContext, Object> clientGuiCreator) {
            this.clientGuiCreator = clientGuiCreator;
            return this;
        }

        public GuiInfo build() {
            return new GuiInfo(this.serverGuiCreator, this.clientGuiCreator);
        }
    }
}

