/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network;

import com.cleanroommc.modularui.ModularUI;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    public static final Consumer<PacketBuffer> EMPTY_PACKET = buffer -> {};

    public static boolean isDedicatedClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isClient(EntityPlayer player) {
        if (player == null) {
            throw new NullPointerException("Can't get side of null player!");
        }
        return player.field_70170_p == null ? player instanceof EntityPlayerSP : player.field_70170_p.field_72995_K;
    }

    public static void writePacketBuffer(PacketBuffer writeTo, PacketBuffer writeFrom) {
        writeTo.func_150787_b(writeFrom.readableBytes());
        writeTo.writeBytes((ByteBuf)writeFrom);
    }

    public static PacketBuffer readPacketBuffer(PacketBuffer buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        return new PacketBuffer(copiedDataBuffer);
    }

    public static void writeItemStack(PacketBuffer buffer, ItemStack itemStack) {
        buffer.func_150788_a(itemStack);
    }

    public static ItemStack readItemStack(PacketBuffer buffer) {
        try {
            return buffer.func_150791_c();
        }
        catch (IOException e) {
            ModularUI.LOGGER.catching((Throwable)e);
            return ItemStack.field_190927_a;
        }
    }

    public static void writeFluidStack(PacketBuffer buffer, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
            NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
            buffer.func_150786_a(fluidStackTag);
        }
    }

    @Nullable
    public static FluidStack readFluidStack(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            return null;
        }
        try {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
        }
        catch (IOException e) {
            ModularUI.LOGGER.throwing((Throwable)e);
            return null;
        }
    }

    public static void writeStringSafe(PacketBuffer buffer, String string) {
        byte[] bytes;
        byte[] bytesTest;
        byte[] byArray = bytesTest = string == null ? new byte[]{} : string.getBytes(StandardCharsets.UTF_8);
        if (bytesTest.length > Short.MAX_VALUE) {
            bytes = new byte[Short.MAX_VALUE];
            System.arraycopy(bytesTest, 0, bytes, 0, Short.MAX_VALUE);
            ModularUI.LOGGER.warn("Warning! Synced string exceeds max length!");
        } else {
            bytes = bytesTest;
        }
        buffer.func_150787_b(bytes.length);
        buffer.writeBytes(bytes);
    }
}

