/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.BitHelper;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import org.jetbrains.annotations.Nullable;

public class DraggablePanelWrapper
implements IDraggable {
    private final ModularPanel panel;
    private final Area movingArea;
    private int relativeClickX;
    private int relativeClickY;
    private boolean moving;

    public DraggablePanelWrapper(ModularPanel panel) {
        this.panel = panel;
        this.movingArea = panel.getArea().createCopy();
    }

    @Override
    public void drawMovingState(float partialTicks) {
        WidgetTree.drawTree(this.panel, this.panel.getContext(), true);
    }

    @Override
    public boolean onDragStart(int button) {
        if (button == 0) {
            this.relativeClickX = this.panel.getContext().getMouseX() - this.panel.getArea().x;
            this.relativeClickY = this.panel.getContext().getMouseY() - this.panel.getArea().y;
            this.movingArea.x = this.panel.getContext().getAbsMouseX() - this.relativeClickX;
            this.movingArea.y = this.panel.getContext().getAbsMouseY() - this.relativeClickY;
            return true;
        }
        return false;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            float y = this.panel.getContext().getAbsMouseY() - this.relativeClickY;
            float x = this.panel.getContext().getAbsMouseX() - this.relativeClickX;
            this.panel.flex().top(y /= (float)(this.panel.getScreen().getViewport().height - this.panel.getArea().height), y).left(x /= (float)(this.panel.getScreen().getViewport().width - this.panel.getArea().width), x);
            this.movingArea.x = this.panel.getArea().x;
            this.movingArea.y = this.panel.getArea().y;
            WidgetTree.resize(this.panel);
        }
    }

    @Override
    public void onDrag(int mouseButton, long timeSinceLastClick) {
        this.movingArea.x = this.panel.getContext().getAbsMouseX() - this.relativeClickX;
        this.movingArea.y = this.panel.getContext().getAbsMouseY() - this.relativeClickY;
    }

    @Override
    @Nullable
    public Area getMovingArea() {
        return this.movingArea;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.panel.setEnabled(!moving);
    }

    @Override
    public void apply(IViewportStack stack, int context) {
        if (BitHelper.hasAnyBits(context, 6144)) {
            stack.pushViewport(this, this.getMovingArea());
            if (this.isMoving()) {
                stack.translate(-this.movingArea.x + this.panel.getContext().globalX(this.panel.getArea().x), -this.movingArea.y + this.panel.getContext().globalY(this.panel.getArea().y));
            }
        }
    }

    @Override
    public void unapply(IViewportStack stack, int context) {
        if (BitHelper.hasNone(context, 16) && BitHelper.hasAnyBits(context, 6144)) {
            stack.popViewport(this);
        }
    }
}

