/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import com.cleanroommc.modularui.sync.ItemSlotSH;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

@Optional.Interface(modid="bogosorter", iface="com.cleanroommc.bogosorter.api.ISortableContainer")
public class ModularContainer
extends Container
implements ISortableContainer {
    private final GuiSyncHandler guiSyncHandler;
    private boolean init = true;
    private final List<ItemSlotSH> slots = new ArrayList<ItemSlotSH>();
    private final List<ItemSlotSH> shiftClickSlots = new ArrayList<ItemSlotSH>();

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ModularContainer) {
            return (ModularContainer)container;
        }
        return null;
    }

    public ModularContainer(GuiSyncHandler guiSyncHandler) {
        this.guiSyncHandler = Objects.requireNonNull(guiSyncHandler);
        this.guiSyncHandler.construct(this);
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public ModularContainer() {
        this.guiSyncHandler = null;
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.guiSyncHandler.detectAndSendChanges(this.init);
        this.init = false;
    }

    public SlotGroup getSlotGroup(ItemSlotSH syncHandler) {
        if (syncHandler.getSlotGroup() == null) {
            return null;
        }
        return this.guiSyncHandler.getSlotGroup(syncHandler.getSlotGroup());
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> this.getSlotGroup((ItemSlotSH)slot).getShiftClickPriority()));
    }

    public void func_190896_a(@NotNull List<ItemStack> items) {
        if (this.field_75151_b.size() != items.size()) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", (Object)this.field_75151_b.size(), (Object)items.size());
        }
        for (int i = 0; i < Math.min(this.field_75151_b.size(), items.size()); ++i) {
            this.func_75139_a(i).func_75215_d(items.get(i));
        }
    }

    public void registerSlot(ItemSlotSH syncHandler) {
        Slot slot = syncHandler.getSlot();
        if (this.field_75151_b.contains(slot)) {
            throw new IllegalArgumentException();
        }
        this.func_75146_a(slot);
        this.slots.add(syncHandler);
        if (syncHandler.getSlotGroup() != null) {
            SlotGroup slotGroup = this.getSyncHandler().getSlotGroup(syncHandler.getSlotGroup());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + syncHandler.getSlotGroup() + "' is not registered!"));
                return;
            }
            slotGroup.addSlot(slot);
            if (slotGroup.allowShiftTransfer()) {
                this.shiftClickSlots.add(syncHandler);
                if (!this.init) {
                    this.sortShiftClickSlots();
                }
            }
        }
    }

    public GuiSyncHandler getSyncHandler() {
        if (this.guiSyncHandler == null) {
            throw new IllegalStateException("GuiSyncHandler is not available for client only GUI's.");
        }
        return this.guiSyncHandler;
    }

    public boolean isClient() {
        return this.guiSyncHandler == null || NetworkUtils.isClient(this.guiSyncHandler.getPlayer());
    }

    public boolean isClientOnly() {
        return this.guiSyncHandler == null;
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return true;
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ItemSlotSH slot = this.slots.get(index);
        if (!slot.isPhantom() && !(stack = slot.getSlot().func_75211_c()).func_190926_b()) {
            ItemStack remainder = this.transferItem(slot, stack.func_77946_l());
            stack.func_190920_e(remainder.func_190916_E());
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack transferItem(ItemSlotSH fromSlot, ItemStack stack) {
        SlotGroup fromSlotGroup = this.getSlotGroup(fromSlot);
        for (ItemSlotSH slot : this.shiftClickSlots) {
            int maxSize;
            SlotGroup slotGroup = this.getSlotGroup(slot);
            boolean valid = slotGroup != null && slotGroup != fromSlotGroup;
            if (!valid || !slot.getSlot().func_111238_b() || !slot.isItemValid(stack)) continue;
            ItemStack itemstack = slot.getSlot().func_75211_c();
            if (slot.isPhantom()) {
                if (!itemstack.func_190926_b() && (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)itemstack) || itemstack.func_190916_E() >= slot.getSlot().func_178170_b(itemstack))) continue;
                slot.getSlot().func_75215_d(stack.func_77946_l());
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)itemstack)) continue;
            int j = itemstack.func_190916_E() + stack.func_190916_E();
            if (j <= (maxSize = Math.min(slot.getSlot().func_75219_a(), stack.func_77976_d()))) {
                stack.func_190920_e(0);
                itemstack.func_190920_e(j);
                slot.getSlot().func_75218_e();
            } else if (itemstack.func_190916_E() < maxSize) {
                stack.func_190918_g(maxSize - itemstack.func_190916_E());
                itemstack.func_190920_e(maxSize);
                slot.getSlot().func_75218_e();
            }
            if (!stack.func_190926_b()) continue;
            return stack;
        }
        for (ItemSlotSH syncHandler : this.shiftClickSlots) {
            Slot slot = syncHandler.getSlot();
            ItemStack itemstack = slot.func_75211_c();
            SlotGroup slotGroup = this.getSlotGroup(syncHandler);
            boolean valid = slotGroup != null && slotGroup != fromSlotGroup;
            if (!valid || !slot.func_111238_b() || !itemstack.func_190926_b() || !slot.func_75214_a(stack)) continue;
            if (stack.func_190916_E() > slot.func_75219_a()) {
                slot.func_75215_d(stack.func_77979_a(slot.func_75219_a()));
                break;
            }
            slot.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
            break;
        }
        return stack;
    }

    private static boolean isPlayerSlot(Slot slot) {
        IItemHandler iItemHandler;
        if (slot == null) {
            return false;
        }
        if (slot.field_75224_c instanceof InventoryPlayer) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        if (slot instanceof SlotItemHandler && ((iItemHandler = ((SlotItemHandler)slot).getItemHandler()) instanceof PlayerMainInvWrapper || iItemHandler instanceof PlayerInvWrapper)) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        return false;
    }

    public void buildSortingContext(ISortingContextBuilder builder) {
        for (SlotGroup slotGroup : this.getSyncHandler().getSlotGroups()) {
            if (!slotGroup.isAllowSorting()) continue;
            builder.addSlotGroup(slotGroup.getRowSize(), slotGroup.getSlots());
        }
    }
}

