/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.IWidgetList;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularPanel
extends ParentWidget<ModularPanel>
implements IViewport {
    private static final int tapTime = 200;
    private String name;
    private ModularScreen screen;
    private final LinkedList<LocatedWidget> hovering = new LinkedList();
    private final List<Interactable> acceptedInteractions = new ArrayList<Interactable>();
    private boolean isMouseButtonHeld = false;
    private boolean isKeyHeld = false;
    @Nullable
    private LocatedWidget lastPressed;
    private long timePressed;
    private int lastMouseButton;
    private Animator animator;
    private float scale = 1.0f;
    private float alpha = 1.0f;

    public static ModularPanel defaultPanel(GuiContext context) {
        return ModularPanel.defaultPanel(context, 176, 166);
    }

    public static ModularPanel defaultPanel(GuiContext context, int width, int height) {
        ModularPanel panel = new ModularPanel(context);
        panel.flex().size(width, height).align(Alignment.Center);
        return panel;
    }

    public ModularPanel(GuiContext context) {
        this.setContext(context);
        context.addJeiExclusionArea(this);
    }

    public ModularPanel name(String name) {
        if (this.screen != null) {
            throw new IllegalStateException("Name must be set before initialization!");
        }
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        return this;
    }

    @Override
    public Area getParentArea() {
        return this.getScreen().getViewport();
    }

    public boolean isOpen() {
        return this.screen != null;
    }

    public void openIn(ModularScreen screen) {
        if (this.screen != null) {
            throw new IllegalStateException("Panel is already open!");
        }
        screen.getWindowManager().openPanel(this);
    }

    public void closeIfOpen() {
        if (this.isOpen()) {
            this.screen.closePanel(this);
        }
    }

    public void animateClose() {
        if (ModularUIConfig.panelOpenCloseAnimationTime <= 0) {
            this.closeIfOpen();
            return;
        }
        if (this.isOpen() && !this.isOpening() && !this.isClosing()) {
            this.animator.setEndCallback(val -> this.screen.closePanel(this));
            this.animator.backward();
        }
    }

    @Override
    public WidgetTheme getWidgetTheme(ITheme theme) {
        return theme.getPanelTheme();
    }

    @Override
    public void onFrameUpdate() {
        this.gatherWidgets();
    }

    @Override
    public void getWidgetsAt(Stack<IViewport> viewports, IWidgetList widgets, int x, int y) {
        if (this.getArea().isInside(x, y)) {
            widgets.add(this, viewports);
        }
        if (this.hasChildren()) {
            IViewport.getChildrenAt(this, viewports, widgets, x, y);
        }
    }

    public void gatherWidgets() {
        this.hovering.clear();
        if (!this.isEnabled()) {
            return;
        }
        IWidgetList widgetList = new IWidgetList(){

            @Override
            public void add(IWidget widget, List<IViewport> viewports) {
                ModularPanel.this.hovering.addFirst(new LocatedWidget(widget, viewports));
            }

            @Override
            public IWidget peek() {
                return this.isEmpty() ? null : (IWidget)((LocatedWidget)ModularPanel.this.hovering.peekFirst()).getElement();
            }

            @Override
            public boolean isEmpty() {
                return ModularPanel.this.hovering.isEmpty();
            }

            @Override
            public int size() {
                return ModularPanel.this.hovering.size();
            }
        };
        this.getContext().reset();
        Stack<IViewport> viewports = new Stack<IViewport>();
        viewports.push(this);
        this.apply(this.getContext(), 2048);
        this.getWidgetsAt(viewports, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        this.unapply(this.getContext(), 2048);
        viewports.pop();
        this.getContext().reset();
    }

    protected void validateName() {
        if (this.name == null) {
            throw new IllegalArgumentException("Non main panels must be given a name via .name()");
        }
    }

    @MustBeInvokedByOverriders
    public void onOpen(ModularScreen screen) {
        this.screen = screen;
        if (this.name == null) {
            if (this == screen.getMainPanel()) {
                this.name = "Main";
            } else {
                throw new IllegalArgumentException("Non main panels must be given a name via .name()");
            }
        }
        this.initialise(this);
        if (ModularUIConfig.panelOpenCloseAnimationTime <= 0) {
            return;
        }
        this.scale = 0.75f;
        this.alpha = 0.0f;
        if (this.animator == null) {
            this.animator = new Animator(ModularUIConfig.panelOpenCloseAnimationTime, Interpolation.QUINT_OUT).setValueBounds(0.0, 1.0).setCallback(val -> {
                this.alpha = (float)val;
                this.scale = (float)val * 0.25f + 0.75f;
            });
        }
        this.animator.setEndCallback(value -> {
            this.scale = 1.0f;
            this.alpha = 1.0f;
        });
        this.animator.forward();
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.getContext().removeJeiExclusionArea(this);
        super.dispose();
        this.screen = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ApiStatus.OverrideOnly
    public boolean onMousePressed(int mouseButton) {
        if (!this.isValid()) {
            return false;
        }
        LocatedWidget pressed = LocatedWidget.EMPTY;
        boolean result = false;
        if (this.hovering.isEmpty()) {
            if (this.closeOnOutOfBoundsClick()) {
                this.animateClose();
                result = true;
            }
        } else {
            int flag = 322;
            block6: for (LocatedWidget widget : this.hovering) {
                widget.applyViewports(this.getContext(), flag);
                if (widget.getElement() instanceof Interactable) {
                    Interactable interactable = (Interactable)widget.getElement();
                    switch (interactable.onMousePressed(mouseButton)) {
                        case IGNORE: {
                            break;
                        }
                        case ACCEPT: {
                            if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                                this.acceptedInteractions.add(interactable);
                            }
                            pressed = widget;
                            break;
                        }
                        case STOP: {
                            pressed = LocatedWidget.EMPTY;
                            result = true;
                            widget.unapplyViewports(this.getContext(), flag);
                            break block6;
                        }
                        case SUCCESS: {
                            if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                                this.acceptedInteractions.add(interactable);
                            }
                            pressed = widget;
                            result = true;
                            widget.unapplyViewports(this.getContext(), flag);
                            break block6;
                        }
                    }
                }
                if (this.getContext().onHoveredClick(mouseButton, widget)) {
                    pressed = LocatedWidget.EMPTY;
                    result = true;
                    widget.unapplyViewports(this.getContext(), flag | 0x1000 | 0x10);
                    break;
                }
                widget.unapplyViewports(this.getContext(), flag);
            }
        }
        if (result && pressed.getElement() instanceof IFocusedWidget) {
            this.getContext().focus(pressed, true);
        } else {
            this.getContext().focus(null);
        }
        if (!this.isKeyHeld && !this.isMouseButtonHeld) {
            this.lastPressed = pressed;
            if (this.lastPressed.getElement() != null) {
                this.timePressed = Minecraft.func_71386_F();
            }
            this.lastMouseButton = mouseButton;
            this.isMouseButtonHeld = true;
        }
        return result;
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseRelease(int mouseButton) {
        if (!this.isValid() || !this.isEnabled()) {
            return false;
        }
        int flag = 578;
        if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseRelease(mouseButton), false, flag).booleanValue()) {
            return true;
        }
        boolean result = false;
        boolean tryTap = mouseButton == this.lastMouseButton && Minecraft.func_71386_F() - this.timePressed < 200L;
        for (LocatedWidget widget2 : this.hovering) {
            if (!(widget2.getElement() instanceof Interactable)) continue;
            Interactable interactable = (Interactable)widget2.getElement();
            widget2.applyViewports(this.getContext(), flag);
            if (interactable.onMouseRelease(mouseButton)) {
                result = true;
                widget2.unapplyViewports(this.getContext(), flag);
                break;
            }
            if (tryTap && this.acceptedInteractions.remove(interactable)) {
                Interactable.Result tabResult = interactable.onMouseTapped(mouseButton);
                switch (tabResult) {
                    case STOP: 
                    case SUCCESS: {
                        tryTap = false;
                    }
                }
            }
            widget2.unapplyViewports(this.getContext(), flag);
        }
        this.acceptedInteractions.clear();
        this.lastMouseButton = -1;
        this.timePressed = 0L;
        this.isMouseButtonHeld = false;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ApiStatus.OverrideOnly
    public boolean onKeyPressed(char typedChar, int keyCode) {
        if (!this.isValid()) {
            return false;
        }
        int flag = 386;
        switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyPressed(typedChar, keyCode), Interactable.Result.IGNORE, flag)) {
            case STOP: 
            case SUCCESS: {
                if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                    this.lastPressed = this.getContext().getFocusedWidget();
                    if (this.lastPressed != null) {
                        this.timePressed = Minecraft.func_71386_F();
                    }
                    this.lastMouseButton = keyCode;
                    this.isKeyHeld = true;
                }
                return true;
            }
        }
        LocatedWidget pressed = null;
        boolean result = false;
        block9: for (LocatedWidget widget2 : this.hovering) {
            if (!(widget2.getElement() instanceof Interactable)) continue;
            Interactable interactable = (Interactable)widget2.getElement();
            widget2.applyViewports(this.getContext(), flag);
            switch (interactable.onKeyPressed(typedChar, keyCode)) {
                case IGNORE: {
                    break;
                }
                case ACCEPT: {
                    if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                        this.acceptedInteractions.add(interactable);
                    }
                    pressed = widget2;
                    break;
                }
                case STOP: {
                    pressed = null;
                    result = true;
                    widget2.unapplyViewports(this.getContext(), flag);
                    break block9;
                }
                case SUCCESS: {
                    if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                        this.acceptedInteractions.add(interactable);
                    }
                    pressed = widget2;
                    result = true;
                    widget2.unapplyViewports(this.getContext(), flag);
                    break block9;
                }
            }
        }
        if (!this.isKeyHeld && !this.isMouseButtonHeld) {
            this.lastPressed = pressed;
            if (this.lastPressed != null) {
                this.timePressed = Minecraft.func_71386_F();
            }
            this.lastMouseButton = keyCode;
            this.isKeyHeld = true;
        }
        return result;
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyRelease(char typedChar, int keyCode) {
        if (!this.isValid()) {
            return false;
        }
        int flag = 642;
        if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyRelease(typedChar, keyCode), false, flag).booleanValue()) {
            return true;
        }
        boolean result = false;
        boolean tryTap = keyCode == this.lastMouseButton && Minecraft.func_71386_F() - this.timePressed < 200L;
        for (LocatedWidget widget2 : this.hovering) {
            if (!(widget2.getElement() instanceof Interactable)) continue;
            Interactable interactable = (Interactable)widget2.getElement();
            widget2.applyViewports(this.getContext(), flag);
            if (interactable.onKeyRelease(typedChar, keyCode)) {
                result = true;
                widget2.unapplyViewports(this.getContext(), flag);
                break;
            }
            if (tryTap && this.acceptedInteractions.remove(interactable)) {
                Interactable.Result tabResult = interactable.onKeyTapped(typedChar, keyCode);
                switch (tabResult) {
                    case STOP: 
                    case SUCCESS: {
                        tryTap = false;
                    }
                }
            }
            widget2.unapplyViewports(this.getContext(), flag);
        }
        this.acceptedInteractions.clear();
        this.lastMouseButton = -1;
        this.timePressed = 0L;
        this.isKeyHeld = false;
        return result;
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (!this.isValid()) {
            return false;
        }
        int flag = 1090;
        if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseScroll(scrollDirection, amount), false, flag).booleanValue()) {
            return true;
        }
        if (this.hovering.isEmpty()) {
            return false;
        }
        for (LocatedWidget widget2 : this.hovering) {
            if (!(widget2.getElement() instanceof Interactable)) continue;
            Interactable interactable = (Interactable)widget2.getElement();
            widget2.applyViewports(this.getContext(), flag);
            boolean result = interactable.onMouseScroll(scrollDirection, amount);
            widget2.unapplyViewports(this.getContext(), flag);
            if (!result) continue;
            return true;
        }
        return true;
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        if (!this.isValid()) {
            return false;
        }
        if (this.isMouseButtonHeld && mouseButton == this.lastMouseButton && this.lastPressed != null && this.lastPressed.getElement() instanceof Interactable) {
            this.lastPressed.applyViewports(this.getContext(), 8258);
            ((Interactable)this.lastPressed.getElement()).onMouseDrag(mouseButton, timeSinceClick);
            this.lastPressed.unapplyViewports(this.getContext(), 8258);
            return true;
        }
        return false;
    }

    private <T, W extends IWidget & IFocusedWidget> T interactFocused(Function<W, T> function, T defaultValue, int context) {
        LocatedWidget focused = this.getContext().getFocusedWidget();
        T result = defaultValue;
        if (focused.getElement() instanceof Interactable) {
            Interactable interactable = (Interactable)focused.getElement();
            focused.applyViewports(this.getContext(), context);
            result = function.apply((IWidget)((Object)interactable));
            focused.unapplyViewports(this.getContext(), context);
        }
        return result;
    }

    public boolean isDraggable() {
        return this.getScreen().getMainPanel() != this;
    }

    public boolean disablePanelsBelow() {
        return false;
    }

    public boolean closeOnOutOfBoundsClick() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public GuiContext getContext() {
        return super.getContext();
    }

    @Override
    public ModularScreen getScreen() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.screen;
    }

    @NotNull
    public LinkedList<LocatedWidget> getHovering() {
        return this.hovering;
    }

    @Nullable
    public IWidget getTopHovering() {
        LocatedWidget lw = this.getTopHoveringLocated();
        return lw == null ? null : (IWidget)lw.getElement();
    }

    @Nullable
    public LocatedWidget getTopHoveringLocated() {
        for (LocatedWidget widget : this.hovering) {
            if (!((IWidget)widget.getElement()).canHover()) continue;
            return widget;
        }
        return null;
    }

    public boolean isOpening() {
        return this.animator != null && this.animator.isRunningForwards();
    }

    public boolean isClosing() {
        return this.animator != null && this.animator.isRunningBackwards();
    }

    public float getScale() {
        return this.scale;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void apply(IViewportStack stack, int context) {
        stack.pushViewport(this, this.getArea());
    }

    @Override
    public void unapply(IViewportStack stack, int context) {
        stack.popViewport(this);
    }

    public ModularPanel bindPlayerInventory() {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory());
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.getName();
    }
}

