/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.WindowManager;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import com.cleanroommc.modularui.sync.ItemSlotSH;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.Dialog;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public abstract class ModularScreen {
    private final String owner;
    private final String name;
    private final WindowManager windowManager;
    public final GuiContext context;
    private final Area viewport = new Area();
    private final Map<Class<?>, List<IGuiAction>> guiActionListeners = new Object2ObjectOpenHashMap();
    private GuiScreenWrapper screenWrapper;
    private GuiSyncHandler syncHandler;

    public static boolean isScreen(@Nullable GuiScreen guiScreen, String owner, String name) {
        if (guiScreen instanceof GuiScreenWrapper) {
            ModularScreen screen = ((GuiScreenWrapper)guiScreen).getScreen();
            return screen.getOwner().equals(owner) && screen.getName().equals(name);
        }
        return false;
    }

    public static boolean isScreen(@Nullable GuiScreen guiScreen, String name) {
        return ModularScreen.isScreen(guiScreen, "modularui", name);
    }

    public static boolean isActive(String owner, String name) {
        return ModularScreen.isScreen(Minecraft.func_71410_x().field_71462_r, owner, name);
    }

    public static boolean isActive(String name) {
        return ModularScreen.isActive("modularui", name);
    }

    @Nullable
    public static ModularScreen getCurrent() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiScreenWrapper) {
            return ((GuiScreenWrapper)Minecraft.func_71410_x().field_71462_r).getScreen();
        }
        return null;
    }

    public ModularScreen(@NotNull String owner, @NotNull String name) {
        this.owner = owner;
        this.name = name;
        this.windowManager = new WindowManager(this);
        this.context = new GuiContext(this);
        ModularPanel panel = this.buildUI(this.context);
        if (panel.getFlex() == null) {
            panel.flex().size(1.0f, 1.0f);
        }
        this.windowManager.construct(panel);
    }

    public ModularScreen(@NotNull String name) {
        this("modularui", name);
    }

    @ApiStatus.Internal
    @MustBeInvokedByOverriders
    public void construct(GuiScreenWrapper wrapper, GuiSyncHandler syncHandler) {
        if (this.screenWrapper != null) {
            throw new IllegalStateException("ModularScreen is already constructed!");
        }
        if (wrapper == null) {
            throw new NullPointerException("GuiScreenWrapper must not be null!");
        }
        this.screenWrapper = wrapper;
        this.syncHandler = syncHandler;
        this.screenWrapper.updateArea(this.windowManager.getMainPanel().getArea());
    }

    public void onResize(int width, int height) {
        this.viewport.set(0, 0, width, height);
        this.viewport.z(0);
        this.viewportSet();
        this.context.pushViewport(null, this.viewport);
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            WidgetTree.resize(panel);
        }
        this.context.popViewport(null);
        this.screenWrapper.updateArea(this.windowManager.getMainPanel().getArea());
    }

    @ApiStatus.OverrideOnly
    public abstract ModularPanel buildUI(GuiContext var1);

    public void onOpen() {
        this.windowManager.init();
        if (!this.getContainer().isClientOnly()) {
            this.windowManager.getOpenPanels().forEach(panel -> WidgetTree.foreachChildByLayer(panel, widget -> {
                if (widget instanceof ISynced) {
                    ((ISynced)((Object)widget)).initialiseSyncHandler(this.syncHandler);
                }
                return true;
            }));
        }
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        this.windowManager.closeAll();
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean force) {
        if (this.isActive()) {
            if (force) {
                this.context.mc.field_71439_g.func_71053_j();
                return;
            }
            if (!this.getMainPanel().isOpening() && !this.getMainPanel().isClosing()) {
                this.getMainPanel().animateClose();
            }
        }
    }

    public void openPanel(ModularPanel panel) {
        this.windowManager.openPanel(panel);
    }

    public void closePanel(ModularPanel panel) {
        this.windowManager.closePanel(panel);
    }

    public boolean isPanelOpen(String name) {
        return this.windowManager.isPanelOpen(name);
    }

    @ApiStatus.OverrideOnly
    public void onUpdate() {
        this.context.tick();
    }

    @MustBeInvokedByOverriders
    public void onFrameUpdate() {
        this.windowManager.clearQueue();
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            WidgetTree.onFrameUpdate(panel);
        }
        this.context.onFrameUpdate();
    }

    protected void viewportSet() {
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.context.updateState(mouseX, mouseY, partialTicks);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        this.context.reset();
        this.context.pushViewport(null, this.viewport);
        for (ModularPanel panel : this.windowManager.getReverseOpenPanels()) {
            if (panel.disablePanelsBelow()) {
                GuiDraw.drawSolidRect(0.0f, 0.0f, this.viewport.w(), this.viewport.h(), Color.argb(16, 16, 16, (int)(125.0f * panel.getAlpha())));
            }
            WidgetTree.drawTree(panel, this.context);
        }
        this.context.popViewport(null);
        this.context.postRenderCallbacks.forEach(element -> element.accept(this.context));
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
    }

    public void drawForeground(float partialTicks) {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        this.context.reset();
        this.context.pushViewport(null, this.viewport);
        for (ModularPanel panel : this.windowManager.getReverseOpenPanels()) {
            if (!panel.isEnabled()) continue;
            WidgetTree.drawTreeForeground(panel, this.context);
        }
        this.context.drawDraggable();
        this.context.popViewport(null);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
    }

    public boolean onMousePressed(int mouseButton) {
        this.context.updateEventState();
        for (IGuiAction.MousePressed action : this.getGuiActionListeners(IGuiAction.MousePressed.class)) {
            action.press(mouseButton);
        }
        if (this.context.onMousePressed(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onMousePressed(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseRelease(int mouseButton) {
        this.context.updateEventState();
        for (IGuiAction.MouseReleased action : this.getGuiActionListeners(IGuiAction.MouseReleased.class)) {
            action.release(mouseButton);
        }
        if (this.context.onMouseReleased(mouseButton)) {
            return true;
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onMouseRelease(mouseButton)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        this.context.updateEventState();
        for (IGuiAction.KeyPressed action : this.getGuiActionListeners(IGuiAction.KeyPressed.class)) {
            action.press(typedChar, keyCode);
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onKeyPressed(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onKeyRelease(char typedChar, int keyCode) {
        this.context.updateEventState();
        for (IGuiAction.KeyReleased action : this.getGuiActionListeners(IGuiAction.KeyReleased.class)) {
            action.release(typedChar, keyCode);
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onKeyRelease(typedChar, keyCode)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        this.context.updateEventState();
        for (IGuiAction.MouseScroll action : this.getGuiActionListeners(IGuiAction.MouseScroll.class)) {
            action.scroll(scrollDirection, amount);
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onMouseScroll(scrollDirection, amount)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        this.context.updateEventState();
        for (IGuiAction.MouseDrag action : this.getGuiActionListeners(IGuiAction.MouseDrag.class)) {
            action.drag(mouseButton, timeSinceClick);
        }
        for (ModularPanel panel : this.windowManager.getOpenPanels()) {
            if (panel.onMouseDrag(mouseButton, timeSinceClick)) {
                return true;
            }
            if (!panel.disablePanelsBelow()) continue;
            break;
        }
        return false;
    }

    public <T> void openDialog(Consumer<Dialog<T>> dialogBuilder) {
        this.openDialog(dialogBuilder, null);
    }

    public <T> void openDialog(Consumer<Dialog<T>> dialogBuilder, Consumer<T> resultConsumer) {
        Dialog<T> dialog = new Dialog<T>(this.context, resultConsumer);
        dialog.flex().size(150, 100).align(Alignment.Center);
        dialog.background(GuiTextures.BACKGROUND);
        dialogBuilder.accept(dialog);
        this.openPanel(dialog);
    }

    @ApiStatus.Internal
    public void setFocused(boolean focus) {
        this.screenWrapper.func_193975_a(focus);
    }

    public boolean isActive() {
        return ModularScreen.getCurrent() == this;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.owner, this.name);
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public GuiSyncHandler getSyncHandler() {
        return this.getContainer().getSyncHandler();
    }

    public ModularPanel getMainPanel() {
        return this.windowManager.getMainPanel();
    }

    public GuiScreenWrapper getScreenWrapper() {
        return this.screenWrapper;
    }

    public Area getViewport() {
        return this.viewport;
    }

    public void registerItemSlot(ItemSlotSH syncHandler) {
        this.getContainer().registerSlot(syncHandler);
    }

    public boolean isClientOnly() {
        return this.getSyncHandler() == null;
    }

    public ModularContainer getContainer() {
        return (ModularContainer)this.screenWrapper.field_147002_h;
    }

    private <T extends IGuiAction> List<T> getGuiActionListeners(Class<T> clazz) {
        return this.guiActionListeners.getOrDefault(clazz, Collections.emptyList());
    }

    public void registerGuiActionListener(IGuiAction action) {
        this.guiActionListeners.computeIfAbsent(ModularScreen.getGuiActionClass(action), key -> new ArrayList()).add(action);
    }

    @ApiStatus.Internal
    public void removeGuiActionListener(IGuiAction action) {
        this.guiActionListeners.getOrDefault(ModularScreen.getGuiActionClass(action), Collections.emptyList()).remove(action);
    }

    private static Class<?> getGuiActionClass(IGuiAction action) {
        Class<?>[] classes;
        for (Class<?> clazz : classes = action.getClass().getInterfaces()) {
            if (!IGuiAction.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new IllegalArgumentException();
    }

    public static ModularScreen simple(@NotNull String name, Function<GuiContext, ModularPanel> panel) {
        return ModularScreen.simple("modularui", name, panel);
    }

    public static ModularScreen simple(@NotNull String owner, @NotNull String name, final Function<GuiContext, ModularPanel> panel) {
        return new ModularScreen(owner, name){

            @Override
            public ModularPanel buildUI(GuiContext context) {
                return (ModularPanel)panel.apply(context);
            }
        };
    }

    public static enum UpOrDown {
        UP(1),
        DOWN(-1);

        public final int modifier;

        private UpOrDown(int modifier) {
            this.modifier = modifier;
        }

        public boolean isUp() {
            return this == UP;
        }

        public boolean isDown() {
            return this == DOWN;
        }
    }
}

