/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.IconRenderer;
import com.cleanroommc.modularui.drawable.TextIcon;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.Nullable;

public class Tooltip {
    private final List<IDrawable> lines = new ArrayList<IDrawable>();
    private List<IDrawable> additionalLines = new ArrayList<IDrawable>();
    private Area excludeArea;
    private Pos pos = ModularUIConfig.tooltipPos;
    private Consumer<Tooltip> tooltipBuilder;
    private int showUpTimer = 0;
    private int x = 0;
    private int y = 0;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean textShadow = true;
    private int textColor;
    private float scale;
    private Alignment alignment;
    private boolean dirty;

    public Tooltip() {
        this.textColor = Color.WHITE.normal;
        this.scale = 1.0f;
        this.alignment = Alignment.TopLeft;
        this.dirty = true;
    }

    public void buildTooltip() {
        this.dirty = false;
        this.lines.clear();
        List<IDrawable> additionalLines = this.additionalLines;
        this.additionalLines = this.lines;
        if (this.tooltipBuilder != null) {
            this.tooltipBuilder.accept(this);
        }
        this.lines.addAll(additionalLines);
        this.additionalLines = additionalLines;
    }

    public void draw(GuiContext context) {
        if (this.isEmpty()) {
            return;
        }
        if (this.maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
        }
        Area screen = context.screen.getViewport();
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        IconRenderer renderer = IconRenderer.SHARED;
        List<String> textLines = Collections.emptyList();
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(ItemStack.field_190927_a, Collections.emptyList(), mouseX, mouseY, screen.width, screen.height, this.maxWidth, TextRenderer.getFontRenderer());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        int screenWidth = event.getScreenWidth();
        int screenHeight = event.getScreenHeight();
        this.maxWidth = event.getMaxWidth();
        renderer.setShadow(this.textShadow);
        renderer.setColor(this.textColor);
        renderer.setScale(this.scale);
        renderer.setAlignment(this.alignment, this.maxWidth);
        renderer.setSimulate(true);
        renderer.setPos(0, 0);
        renderer.draw(context, this.lines);
        Rectangle area = this.determineTooltipArea(context, this.lines, renderer, screenWidth, screenHeight, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GuiDraw.drawTooltipBackground(textLines, area.x, area.y, area.width, area.height, 300);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(ItemStack.field_190927_a, textLines, area.x, area.y, TextRenderer.getFontRenderer(), area.width, area.height));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.setSimulate(false);
        renderer.setPos(area.x, area.y);
        renderer.draw(context, this.lines);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(ItemStack.field_190927_a, textLines, area.x, area.y, TextRenderer.getFontRenderer(), area.width, area.height));
    }

    public Rectangle determineTooltipArea(GuiContext context, List<IDrawable> lines, IconRenderer renderer, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        int width = (int)renderer.getLastWidth();
        int height = (int)renderer.getLastHeight();
        if (this.pos == null) {
            return new Rectangle(this.x, this.y, width, height);
        }
        if (this.pos == Pos.NEXT_TO_MOUSE) {
            boolean isOnRightSide = mouseX > screenWidth / 2;
            return new Rectangle();
        }
        if (this.excludeArea == null) {
            throw new IllegalStateException();
        }
        int minWidth = 0;
        for (IDrawable line : lines) {
            if (line instanceof IIcon && !(line instanceof TextIcon)) {
                minWidth = Math.max(minWidth, ((IIcon)line).getWidth());
                continue;
            }
            if (line instanceof IKey) continue;
            minWidth = Math.max(minWidth, 18);
        }
        int shiftAmount = 10;
        int borderSpace = 7;
        int x = 0;
        int y = 0;
        if (this.pos.vertical) {
            int xArea = this.excludeArea.x;
            if (width < this.excludeArea.width) {
                x = xArea + shiftAmount;
            } else {
                x = xArea - shiftAmount;
                if (x < borderSpace) {
                    x = borderSpace;
                } else if (x + width > screenWidth - borderSpace) {
                    int maxWidth = Math.max(minWidth, screenWidth - x - borderSpace);
                    renderer.setAlignment(this.alignment, maxWidth);
                    renderer.draw(context, lines);
                    width = (int)renderer.getLastWidth();
                    height = (int)renderer.getLastHeight();
                }
            }
            Pos pos = this.pos;
            if (this.pos == Pos.VERTICAL) {
                int bottomSpace = screenHeight - this.excludeArea.y - this.excludeArea.height;
                Pos pos2 = pos = bottomSpace < height && bottomSpace < this.excludeArea.y ? Pos.ABOVE : Pos.BELOW;
            }
            if (pos == Pos.BELOW) {
                y = this.excludeArea.y + this.excludeArea.height + borderSpace;
            } else if (pos == Pos.ABOVE) {
                y = this.excludeArea.y - height - borderSpace;
            }
        } else if (this.pos.horizontal) {
            boolean usedMoreSpaceSide = false;
            Pos pos = this.pos;
            if (this.pos == Pos.HORIZONTAL) {
                if (this.excludeArea.x > screenWidth - this.excludeArea.x - this.excludeArea.width) {
                    pos = Pos.LEFT;
                    x = 0;
                } else {
                    pos = Pos.RIGHT;
                    x = screenWidth - this.excludeArea.x - this.excludeArea.width + borderSpace;
                }
            }
            int yArea = this.excludeArea.y;
            if (height < this.excludeArea.height) {
                y = yArea + shiftAmount;
            } else {
                y = yArea - shiftAmount;
                if (y < borderSpace) {
                    y = borderSpace;
                }
            }
            if (x + width > screenWidth - borderSpace) {
                int maxWidth = pos == Pos.LEFT ? Math.max(minWidth, this.excludeArea.x - borderSpace * 2) : Math.max(minWidth, screenWidth - this.excludeArea.x - this.excludeArea.width - borderSpace * 2);
                usedMoreSpaceSide = true;
                renderer.setAlignment(this.alignment, maxWidth);
                renderer.draw(context, lines);
                width = (int)renderer.getLastWidth();
                height = (int)renderer.getLastHeight();
            }
            if (this.pos == Pos.HORIZONTAL && !usedMoreSpaceSide) {
                int rightSpace = screenWidth - this.excludeArea.x - this.excludeArea.width;
                Pos pos3 = pos = rightSpace < width && rightSpace < this.excludeArea.x ? Pos.LEFT : Pos.RIGHT;
            }
            if (pos == Pos.RIGHT) {
                x = this.excludeArea.x + this.excludeArea.width + borderSpace;
            } else if (pos == Pos.LEFT) {
                x = this.excludeArea.x - width - borderSpace;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean isEmpty() {
        if (this.dirty) {
            this.buildTooltip();
        }
        return this.lines.isEmpty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public Area getExcludeArea() {
        return this.excludeArea;
    }

    public int getShowUpTimer() {
        return this.showUpTimer;
    }

    @Nullable
    public Consumer<Tooltip> getTooltipBuilder() {
        return this.tooltipBuilder;
    }

    public Tooltip excludeArea(Area area) {
        this.excludeArea = area;
        return this;
    }

    public Tooltip pos(Pos pos) {
        this.pos = pos;
        return this;
    }

    public Tooltip pos(int x, int y) {
        this.pos = null;
        this.x = x;
        this.y = y;
        return this;
    }

    public Tooltip alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Tooltip textShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public Tooltip textColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public Tooltip scale(float scale) {
        this.scale = scale;
        return this;
    }

    public Tooltip showUpTimer(int showUpTimer) {
        this.showUpTimer = showUpTimer;
        return this;
    }

    public Tooltip tooltipBuilder(Consumer<Tooltip> tooltipBuilder) {
        Consumer<Tooltip> existingBuilder = this.tooltipBuilder;
        this.tooltipBuilder = existingBuilder != null ? tooltip -> {
            existingBuilder.accept(this);
            tooltipBuilder.accept(this);
        } : tooltipBuilder;
        return this;
    }

    public Tooltip addLine(IDrawable drawable) {
        this.additionalLines.add(drawable);
        return this;
    }

    public Tooltip addLine(String line) {
        return this.addLine(IKey.str(line));
    }

    public static enum Pos {
        ABOVE(false, true),
        BELOW(false, true),
        LEFT(true, false),
        RIGHT(true, false),
        VERTICAL(false, true),
        HORIZONTAL(true, false),
        NEXT_TO_MOUSE(false, false);

        public final boolean horizontal;
        public final boolean vertical;

        private Pos(boolean horizontal, boolean vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }
    }
}

