/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.utils.ReverseIterable;
import com.cleanroommc.modularui.widget.WidgetTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class WindowManager {
    private final ModularScreen screen;
    private ModularPanel mainPanel;
    private final LinkedList<ModularPanel> panels = new LinkedList();
    private final List<ModularPanel> panelsView = Collections.unmodifiableList(this.panels);
    private final ReverseIterable<ModularPanel> reversePanels = new ReverseIterable<ModularPanel>(this.panelsView);
    private final List<ModularPanel> queueOpenPanels = new ArrayList<ModularPanel>();
    private final List<ModularPanel> queueClosePanels = new ArrayList<ModularPanel>();
    private boolean closed;

    public WindowManager(ModularScreen screen) {
        this.screen = screen;
    }

    void construct(ModularPanel panel) {
        if (this.mainPanel != null) {
            throw new IllegalStateException();
        }
        if (panel == null) {
            throw new NullPointerException();
        }
        this.mainPanel = panel;
    }

    void init() {
        if (this.mainPanel == null) {
            throw new IllegalStateException("WindowManager is not yet constructed!");
        }
        if (this.mainPanel.getName() == null) {
            this.mainPanel.name("Main");
        }
        this.openPanel(this.mainPanel, false);
    }

    public boolean isMainPanel(ModularPanel panel) {
        return this.mainPanel == panel;
    }

    @ApiStatus.Internal
    public void clearQueue() {
        if (!this.queueOpenPanels.isEmpty()) {
            for (ModularPanel panel2 : this.queueOpenPanels) {
                this.openPanel(panel2, true);
            }
            this.queueOpenPanels.clear();
        }
        if (!this.queueClosePanels.isEmpty()) {
            if (this.queueClosePanels.contains(this.mainPanel)) {
                this.panels.removeIf(panel -> {
                    panel.onClose();
                    return true;
                });
                this.screen.close(true);
            } else {
                for (ModularPanel panel2 : this.queueClosePanels) {
                    if (!this.panels.contains(panel2)) {
                        throw new IllegalStateException();
                    }
                    if (!this.panels.remove(panel2)) continue;
                    panel2.onClose();
                }
            }
            this.queueClosePanels.clear();
        }
    }

    private void openPanel(ModularPanel panel, boolean resize) {
        panel.validateName();
        if (this.panels.contains(panel) || this.isPanelOpen(panel.getName())) {
            throw new IllegalStateException();
        }
        this.panels.addFirst(panel);
        panel.onOpen(this.screen);
        if (resize) {
            WidgetTree.resize(panel);
        }
    }

    public boolean isPanelOpen(String name) {
        for (ModularPanel panel : this.panels) {
            if (!panel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ModularScreen getScreen() {
        return this.screen;
    }

    @NotNull
    public ModularPanel getMainPanel() {
        if (this.mainPanel == null) {
            throw new IllegalStateException("WindowManager has not been initialised yet!");
        }
        if (this.closed) {
            throw new IllegalStateException("Screen has been closed");
        }
        return this.mainPanel;
    }

    public ModularPanel getTopMostPanel() {
        return this.panels.peekFirst();
    }

    @Nullable
    public IWidget getTopWidget() {
        for (ModularPanel panel : this.panels) {
            IWidget widget = panel.getTopHovering();
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @Nullable
    public LocatedWidget getTopWidgetLocated() {
        for (ModularPanel panel : this.panels) {
            LocatedWidget widget = panel.getTopHoveringLocated();
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    public void openPanel(@NotNull ModularPanel panel) {
        if (!this.queueOpenPanels.contains(panel)) {
            this.queueOpenPanels.add(panel);
        }
    }

    public void closePanel(@NotNull ModularPanel panel) {
        if (!this.queueClosePanels.contains(panel)) {
            this.queueClosePanels.add(panel);
        }
    }

    public void closeAll() {
        for (ModularPanel panel : this.panels) {
            panel.onClose();
        }
    }

    public void pushUp(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == 0) {
            return;
        }
        this.panels.remove(index);
        this.panels.add(index - 1, window);
    }

    public void pushDown(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == this.panels.size() - 1) {
            return;
        }
        this.panels.remove(index);
        this.panels.add(index + 1, window);
    }

    public void pushToTop(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == 0) {
            return;
        }
        this.panels.remove(index);
        this.panels.addFirst(window);
    }

    public void pushToBottom(@NotNull ModularPanel window) {
        int index = this.panels.indexOf(window);
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index == this.panels.size() - 1) {
            return;
        }
        this.panels.remove(index);
        this.panels.addLast(window);
    }

    @NotNull
    public @UnmodifiableView List<ModularPanel> getOpenPanels() {
        return this.panelsView;
    }

    @NotNull
    public @UnmodifiableView Iterable<ModularPanel> getReverseOpenPanels() {
        return this.reversePanels;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAboutToClose(ModularPanel panel) {
        for (ModularPanel panel1 : this.queueClosePanels) {
            if (panel != panel1) continue;
            return true;
        }
        return false;
    }
}

