/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.core.mixin.GuiContainerAccessor;
import com.cleanroommc.modularui.screen.DraggablePanelWrapper;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.WindowManager;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.theme.ThemeManager;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiContext
extends GuiViewportStack {
    public final Minecraft mc;
    public final FontRenderer font;
    public final ModularScreen screen;
    private ITheme currentTheme;
    private LocatedWidget focusedWidget = LocatedWidget.EMPTY;
    @Nullable
    private IGuiElement hovered;
    private int timeHovered = 0;
    private final HoveredIterable hoveredWidgets;
    private LocatedElement<IDraggable> draggable;
    private int lastButton = -1;
    private long lastClickTime = 0L;
    private int lastDragX;
    private int lastDragY;
    private int mouseX;
    private int mouseY;
    private int mouseButton;
    private int mouseWheel;
    private char typedChar;
    private int keyCode;
    private float partialTicks;
    private long tick;
    private byte jeiState = 0;
    public List<Consumer<GuiContext>> postRenderCallbacks = new ArrayList<Consumer<GuiContext>>();
    private final List<IWidget> jeiExclusionWidgets = new ArrayList<IWidget>();
    private final List<Rectangle> jeiExclusionAreas = new ArrayList<Rectangle>();

    public GuiContext(ModularScreen screen) {
        this.screen = screen;
        this.hoveredWidgets = new HoveredIterable(this.screen.getWindowManager());
        this.mc = ModularUI.getMC();
        this.font = this.mc.field_71466_p;
        this.currentTheme = ThemeManager.getThemeFor(screen.getOwner(), screen.getName());
    }

    public boolean isAbove(IGuiElement widget) {
        return widget.getArea().isInside(this.mouseX, this.mouseY);
    }

    public boolean isHovered() {
        return this.hovered != null;
    }

    public boolean isHovered(IGuiElement guiElement) {
        return this.isHovered() && this.hovered == guiElement;
    }

    public boolean isHoveredFor(IGuiElement guiElement, int ticks) {
        return this.isHovered(guiElement) && this.timeHovered / 3 >= ticks;
    }

    @Nullable
    public IGuiElement getHovered() {
        return this.hovered;
    }

    public Iterable<IGuiElement> getAllBelowMouse() {
        return this.hoveredWidgets;
    }

    public boolean isFocused() {
        return this.focusedWidget.getElement() != null;
    }

    public boolean isFocused(IFocusedWidget widget) {
        return this.focusedWidget.getElement() == widget;
    }

    public LocatedWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void focus(IFocusedWidget widget) {
        this.focus(widget, false);
    }

    public void focus(IFocusedWidget widget, boolean select) {
        this.focus(LocatedWidget.of((IWidget)((Object)widget)), select);
    }

    public void focus(@NotNull LocatedWidget widget, boolean select) {
        IFocusedWidget focusedWidget;
        if (this.focusedWidget.getElement() == widget.getElement()) {
            return;
        }
        if (widget.getElement() != null && !(widget.getElement() instanceof IFocusedWidget)) {
            throw new IllegalArgumentException();
        }
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onRemoveFocus(this);
            this.screen.setFocused(false);
            if (select) {
                focusedWidget.unselect(this);
            }
        }
        this.focusedWidget = widget;
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onFocus(this);
            this.screen.setFocused(true);
            if (select) {
                focusedWidget.selectAll(this);
            }
        }
    }

    public void removeFocus() {
        this.focus(null);
    }

    public boolean focusNext(IWidget parent) {
        return this.focus(parent, -1, 1);
    }

    public boolean focusPrevious(IWidget parent) {
        return this.focus(parent, -1, -1);
    }

    public boolean focus(IWidget parent, int index, int factor) {
        return this.focus(parent, index, factor, false);
    }

    public boolean focus(IWidget parent, int index, int factor, boolean stop) {
        List<IWidget> children = parent.getChildren();
        factor = factor >= 0 ? 1 : -1;
        index += factor;
        while (index >= 0 && index < children.size()) {
            IWidget child = children.get(index);
            if (child.isEnabled()) {
                int start;
                if (child instanceof IFocusedWidget) {
                    this.focus((IFocusedWidget)((Object)child), true);
                    return true;
                }
                int n = start = factor > 0 ? -1 : child.getChildren().size();
                if (this.focus(child, start, factor, true)) {
                    return true;
                }
            }
            index += factor;
        }
        IWidget grandparent = parent.getParent();
        boolean isRoot = grandparent instanceof ModularPanel;
        if (grandparent != null && !stop && (isRoot || grandparent.canBeSeen())) {
            List<IWidget> childs = grandparent.getChildren();
            if (this.focus(grandparent, childs.indexOf(parent), factor)) {
                return true;
            }
            if (isRoot) {
                return this.focus(grandparent, factor > 0 ? -1 : childs.size() - 1, factor);
            }
        }
        return false;
    }

    public boolean hasDraggable() {
        return this.draggable != null;
    }

    public boolean isMouseItemEmpty() {
        return this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
    }

    @ApiStatus.Internal
    public boolean onMousePressed(int button) {
        if ((button == 0 || button == 1) && this.isMouseItemEmpty() && this.hasDraggable()) {
            this.dropDraggable();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onMouseReleased(int button) {
        if (button == this.lastButton && this.isMouseItemEmpty() && this.hasDraggable()) {
            long time = Minecraft.func_71386_F();
            if (time - this.lastClickTime < 200L) {
                return false;
            }
            this.dropDraggable();
            return true;
        }
        return false;
    }

    private void dropDraggable() {
        this.draggable.applyViewports(this, 4194);
        this.draggable.getElement().onDragEnd(this.draggable.getElement().canDropHere(this.getAbsMouseX(), this.getAbsMouseY(), this.hovered));
        this.draggable.getElement().setMoving(false);
        this.draggable.unapplyViewports(this, 4194);
        this.draggable = null;
        this.lastButton = -1;
        this.lastClickTime = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public boolean onHoveredClick(int button, LocatedWidget hovered) {
        LocatedElement<IDraggable> draggable;
        if (button != 0 && button != 1 || !this.isMouseItemEmpty() || this.hasDraggable()) return false;
        IWidget widget = (IWidget)hovered.getElement();
        if (widget instanceof IDraggable) {
            draggable = new LocatedElement<IDraggable>((IDraggable)((Object)widget), hovered.getViewports());
        } else {
            if (!(widget instanceof ModularPanel)) return false;
            ModularPanel panel = (ModularPanel)widget;
            if (!panel.isDraggable() || this.screen.getWindowManager().isAboutToClose(panel)) return false;
            draggable = new LocatedElement<DraggablePanelWrapper>(new DraggablePanelWrapper(panel), Collections.emptyList());
        }
        if (!draggable.getElement().onDragStart(button)) return false;
        draggable.getElement().setMoving(true);
        this.draggable = draggable;
        this.lastButton = button;
        this.lastClickTime = Minecraft.func_71386_F();
        return true;
    }

    @ApiStatus.Internal
    public void drawDraggable() {
        if (this.hasDraggable()) {
            int flag = 4097;
            this.draggable.applyViewports(this, flag);
            this.draggable.getElement().apply(this, flag);
            this.draggable.getElement().drawMovingState(this.partialTicks);
            this.draggable.getElement().unapply(this, flag);
            this.draggable.unapplyViewports(this, flag);
        }
    }

    @ApiStatus.Internal
    public void updateState(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
    }

    @ApiStatus.Internal
    public void updateEventState() {
        this.mouseButton = Mouse.getEventButton();
        this.mouseWheel = Mouse.getEventDWheel();
        this.keyCode = Keyboard.getEventKey();
        this.typedChar = Keyboard.getEventCharacter();
    }

    @ApiStatus.Internal
    public void onFrameUpdate() {
        IWidget hovered = this.screen.getWindowManager().getTopWidget();
        if (this.hasDraggable() && (this.lastDragX != this.mouseX || this.lastDragY != this.mouseY)) {
            this.lastDragX = this.mouseX;
            this.lastDragY = this.mouseY;
            this.draggable.applyViewports(this, 12354);
            this.draggable.getElement().onDrag(this.lastButton, this.lastClickTime);
            this.draggable.unapplyViewports(this, 12354);
        }
        if (this.hovered != hovered) {
            if (this.hovered != null) {
                this.hovered.onMouseEndHover();
            }
            this.hovered = hovered;
            this.timeHovered = 0;
            if (this.hovered != null) {
                this.hovered.onMouseStartHover();
                if (this.hovered instanceof IVanillaSlot) {
                    ((GuiContainerAccessor)((Object)this.screen.getScreenWrapper())).setHoveredSlot(((IVanillaSlot)((Object)this.hovered)).getVanillaSlot());
                } else {
                    ((GuiContainerAccessor)((Object)this.screen.getScreenWrapper())).setHoveredSlot(null);
                }
            }
        } else {
            ++this.timeHovered;
        }
    }

    public void tick() {
        ++this.tick;
    }

    public long getTick() {
        return this.tick;
    }

    public int getMouseX() {
        return this.localX(this.mouseX);
    }

    public int getMouseY() {
        return this.localY(this.mouseY);
    }

    public int getMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getMouseX() : this.getMouseY();
    }

    public int getAbsMouseX() {
        return this.mouseX;
    }

    public int getAbsMouseY() {
        return this.mouseY;
    }

    public int getAbsMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getAbsMouseX() : this.getAbsMouseY();
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getTypedChar() {
        return this.typedChar;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public void enableJei() {
        this.jeiState = 1;
    }

    public void disableJei() {
        this.jeiState = (byte)2;
    }

    public void defaultJei() {
        this.jeiState = 0;
    }

    public boolean isJeiEnabled() {
        switch (this.jeiState) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return !this.screen.getContainer().isClientOnly();
    }

    public void addJeiExclusionArea(Rectangle area) {
        if (!this.jeiExclusionAreas.contains(area)) {
            this.jeiExclusionAreas.add(area);
        }
    }

    public void removeJeiExclusionArea(Rectangle area) {
        this.jeiExclusionAreas.remove(area);
    }

    public void addJeiExclusionArea(IWidget area) {
        if (!this.jeiExclusionWidgets.contains(area)) {
            this.jeiExclusionWidgets.add(area);
        }
    }

    public void removeJeiExclusionArea(IWidget area) {
        this.jeiExclusionWidgets.remove(area);
    }

    public List<Rectangle> getJeiExclusionAreas() {
        return this.jeiExclusionAreas;
    }

    public List<IWidget> getJeiExclusionWidgets() {
        return this.jeiExclusionWidgets;
    }

    public List<Rectangle> getAllJeiExclusionAreas() {
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.jeiExclusionAreas);
        areas.addAll(this.jeiExclusionWidgets.stream().filter(IWidget::isEnabled).map(IWidget::getArea).collect(Collectors.toList()));
        return areas;
    }

    public ITheme getTheme() {
        return this.currentTheme;
    }

    public void useTheme(String theme) {
        ITheme.registerDefaultScreenTheme(this.screen.getOwner(), this.screen.getName(), ITheme.get(theme));
        this.currentTheme = ThemeManager.getThemeFor(this.screen.getOwner(), this.screen.getName());
    }

    private static class HoveredIterable
    implements Iterable<IGuiElement> {
        private final WindowManager windowManager;

        private HoveredIterable(WindowManager windowManager) {
            this.windowManager = windowManager;
        }

        @Override
        @NotNull
        public Iterator<IGuiElement> iterator() {
            return new Iterator<IGuiElement>(){
                private final Iterator<ModularPanel> panelIt;
                private Iterator<LocatedWidget> widgetIt;
                {
                    this.panelIt = windowManager.getOpenPanels().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.widgetIt == null) {
                        if (!this.panelIt.hasNext()) {
                            return false;
                        }
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return this.widgetIt.hasNext();
                }

                @Override
                public IGuiElement next() {
                    if (this.widgetIt == null || !this.widgetIt.hasNext()) {
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return (IGuiElement)this.widgetIt.next().getElement();
                }
            };
        }
    }
}

