/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.IStringSyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.network.PacketBuffer;

public class DoubleSyncHandler
extends ValueSyncHandler<Double>
implements IStringSyncHandler<Double> {
    private final DoubleSupplier getter;
    private final DoubleConsumer setter;
    private double cache;

    public DoubleSyncHandler(DoubleSupplier getter, DoubleConsumer setter) {
        this.getter = getter;
        this.setter = setter;
        this.cache = getter.getAsDouble();
    }

    @Override
    public Double getCachedValue() {
        return this.cache;
    }

    public double getDoubleValue() {
        return this.cache;
    }

    @Override
    public void setValue(Double value) {
        this.cache = value;
    }

    public void setDoubleValue(double cache) {
        this.cache = cache;
    }

    @Override
    public boolean needsSync(boolean isFirstSync) {
        return isFirstSync || this.getter.getAsDouble() != this.getDoubleValue();
    }

    @Override
    public void updateAndWrite(PacketBuffer buffer) {
        this.setDoubleValue(this.getter.getAsDouble());
        buffer.writeDouble(this.getDoubleValue());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setDoubleValue(buffer.readDouble());
        this.setter.accept(this.getDoubleValue());
    }

    @Override
    public void updateFromClient(Double value) {
        this.setter.accept(value);
        this.syncToServer(0, this::updateAndWrite);
    }

    @Override
    public Double fromString(String value) {
        return Double.parseDouble(value);
    }
}

