/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.INumberSyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class EnumSyncHandler<T extends Enum<T>>
extends ValueSyncHandler<T>
implements INumberSyncHandler<T> {
    private final Class<T> enumCLass;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private T cache;

    public EnumSyncHandler(Class<T> enumCLass, Supplier<T> getter, Consumer<T> setter) {
        this.enumCLass = enumCLass;
        this.getter = getter;
        this.setter = setter;
        this.cache = (Enum)getter.get();
    }

    @Override
    public int getCacheAsInt() {
        return ((Enum)this.cache).ordinal();
    }

    @Override
    public T fromInt(int val) {
        return (T)((Enum[])this.enumCLass.getEnumConstants())[val];
    }

    @Override
    public T getCachedValue() {
        return this.cache;
    }

    @Override
    public void setValue(T value) {
        this.cache = value;
    }

    @Override
    public boolean needsSync(boolean isFirstSync) {
        return isFirstSync || this.cache != this.getter.get();
    }

    @Override
    public void updateAndWrite(PacketBuffer buffer) {
        this.setValue((T)((Enum)this.getter.get()));
        buffer.func_179249_a((Enum)this.getCachedValue());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue((T)buffer.func_179257_a(this.enumCLass));
        this.setter.accept(this.getCachedValue());
    }

    @Override
    public void updateFromClient(T value) {
        this.setter.accept(value);
        this.syncToServer(0, this::updateAndWrite);
    }
}

