/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.ClickData;
import com.cleanroommc.modularui.utils.FluidTankHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class FluidSlotSyncHandler
extends ValueSyncHandler<FluidStack> {
    @Nullable
    private FluidStack cache;
    private final IFluidTank fluidTank;
    private final IFluidHandler fluidHandler;
    private boolean canFillSlot = true;
    private boolean canDrainSlot = true;
    private boolean controlsAmount = true;
    private boolean phantom = false;
    @Nullable
    private FluidStack lastStoredPhantomFluid;

    public FluidSlotSyncHandler(IFluidTank fluidTank) {
        this.fluidTank = fluidTank;
        this.fluidHandler = FluidTankHandler.getTankFluidHandler(fluidTank);
    }

    @Override
    @Nullable
    public FluidStack getCachedValue() {
        return this.cache;
    }

    @Override
    public void setValue(@Nullable FluidStack value) {
        this.cache = value;
        this.onValueChanged();
    }

    @Override
    public boolean needsSync(boolean isFirstSync) {
        if (isFirstSync) {
            return true;
        }
        FluidStack current = this.fluidTank.getFluid();
        if (current == this.cache) {
            return false;
        }
        if (current == null || this.cache == null) {
            return true;
        }
        return current.amount != this.cache.amount || !current.isFluidEqual(this.cache);
    }

    @Override
    public void updateAndWrite(PacketBuffer buffer) {
        this.cache = this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().copy() : null;
        NetworkUtils.writeFluidStack(buffer, this.cache);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue(NetworkUtils.readFluidStack(buffer));
    }

    @Override
    public void updateFromClient(FluidStack value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 0) {
            this.read(buf);
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 0) {
            this.read(buf);
        } else if (id == 1) {
            if (this.phantom) {
                this.tryClickPhantom(ClickData.readPacket(buf));
            } else {
                this.tryClickContainer(ClickData.readPacket(buf));
            }
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(ClickData.readPacket(buf));
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        } else if (id == 4) {
            this.fluidTank.drain(Integer.MAX_VALUE, true);
            this.fluidTank.fill(NetworkUtils.readFluidStack(buf), true);
        }
    }

    private void tryClickContainer(ClickData clickData) {
        int maxAttempts;
        EntityPlayer player = this.getSyncHandler().getPlayer();
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        if (!currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return;
        }
        int n = maxAttempts = clickData.shift ? currentStack.func_190916_E() : 1;
        if (clickData.mouseButton == 0 && this.canFillSlot) {
            boolean performedTransfer = false;
            for (int i = 0; i < maxAttempts; ++i) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
                ItemStack remainingStack = result.getResult();
                if (!result.isSuccess() || currentStack.func_190916_E() > 1 && !remainingStack.func_190926_b() && !player.field_71071_by.func_70441_a(remainingStack)) {
                    player.func_71019_a(remainingStack, true);
                    break;
                }
                remainingStack = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true).result;
                if (currentStack.func_190916_E() == 1) {
                    currentStack = remainingStack;
                } else {
                    currentStack.func_190918_g(1);
                }
                performedTransfer = true;
                if (currentStack.func_190926_b()) break;
            }
            FluidStack fluid = this.fluidTank.getFluid();
            if (performedTransfer && fluid != null) {
                this.playSound(fluid, false);
                this.getSyncHandler().setCursorItem(currentStack);
            }
            return;
        }
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (clickData.mouseButton == 1 && this.canDrainSlot && currentFluid != null && currentFluid.amount > 0) {
            boolean performedTransfer = false;
            for (int i = 0; i < maxAttempts; ++i) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
                ItemStack remainingStack = result.getResult();
                if (!result.isSuccess() || currentStack.func_190916_E() > 1 && !remainingStack.func_190926_b() && !player.field_71071_by.func_70441_a(remainingStack)) break;
                remainingStack = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true).result;
                if (currentStack.func_190916_E() == 1) {
                    currentStack = remainingStack;
                } else {
                    currentStack.func_190918_g(1);
                }
                performedTransfer = true;
                if (currentStack.func_190926_b()) break;
            }
            if (performedTransfer) {
                this.playSound(currentFluid, true);
                this.getSyncHandler().setCursorItem(currentStack);
            }
        }
    }

    public void tryClickPhantom(ClickData clickData) {
        EntityPlayer player = this.getSyncHandler().getPlayer();
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        FluidStack currentFluid = this.fluidTank.getFluid();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)currentStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (clickData.mouseButton == 0) {
            if (currentStack.func_190926_b() || fluidHandlerItem == null) {
                if (this.canDrainSlot) {
                    this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
                }
            } else {
                FluidStack cellFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
                if ((this.controlsAmount || currentFluid == null) && cellFluid != null) {
                    if (this.canFillSlot) {
                        if (!this.controlsAmount) {
                            cellFluid.amount = 1;
                        }
                        if (this.fluidTank.fill(cellFluid, true) > 0) {
                            this.lastStoredPhantomFluid = cellFluid.copy();
                        }
                    }
                } else if (this.canDrainSlot) {
                    this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
                }
            }
        } else if (clickData.mouseButton == 1) {
            if (this.canFillSlot) {
                if (currentFluid != null) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.amount = 1000;
                        this.fluidTank.fill(toFill, true);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    FluidStack toFill = this.lastStoredPhantomFluid.copy();
                    toFill.amount = this.controlsAmount ? 1000 : 1;
                    this.fluidTank.fill(toFill, true);
                }
            }
        } else if (clickData.mouseButton == 2 && currentFluid != null && this.canDrainSlot) {
            this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
        }
    }

    public void tryScrollPhantom(ClickData clickData) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        int amount = clickData.mouseButton;
        if (clickData.shift) {
            amount *= 10;
        }
        if (clickData.ctrl) {
            amount *= 100;
        }
        if (clickData.alt) {
            amount *= 1000;
        }
        if (currentFluid == null) {
            if (amount > 0 && this.lastStoredPhantomFluid != null) {
                FluidStack toFill = this.lastStoredPhantomFluid.copy();
                toFill.amount = this.controlsAmount ? amount : 1;
                this.fluidTank.fill(toFill, true);
            }
            return;
        }
        if (amount > 0 && this.controlsAmount) {
            FluidStack toFill = currentFluid.copy();
            toFill.amount = amount;
            this.fluidTank.fill(toFill, true);
        } else if (amount < 0) {
            this.fluidTank.drain(-amount, true);
        }
    }

    private void playSound(FluidStack fluid, boolean fill) {
        EntityPlayer player = this.getSyncHandler().getPlayer();
        SoundEvent soundevent = fill ? fluid.getFluid().getFillSound(fluid) : fluid.getFluid().getEmptySound(fluid);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public IFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public boolean controlsAmount() {
        return this.controlsAmount;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public FluidSlotSyncHandler phantom(boolean phantom) {
        this.phantom = phantom;
        return this;
    }

    public FluidSlotSyncHandler controlsAmount(boolean controlsAmount) {
        this.controlsAmount = controlsAmount;
        if (this.isValid()) {
            this.sync(3, buffer -> buffer.writeBoolean(controlsAmount));
        }
        return this;
    }

    public FluidSlotSyncHandler canDrainSlot(boolean canDrainSlot) {
        this.canDrainSlot = canDrainSlot;
        return this;
    }

    public FluidSlotSyncHandler canFillSlot(boolean canFillSlot) {
        this.canFillSlot = canFillSlot;
        return this;
    }
}

