/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.INumberSyncHandler;
import com.cleanroommc.modularui.api.sync.IStringSyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.network.PacketBuffer;

public class IntSyncHandler
extends ValueSyncHandler<Integer>
implements INumberSyncHandler<Integer>,
IStringSyncHandler<Integer> {
    private int cache;
    private final IntSupplier getter;
    private final IntConsumer setter;

    public IntSyncHandler(IntSupplier getter, IntConsumer setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public Integer getCachedValue() {
        return this.cache;
    }

    public int getInt() {
        return this.cache;
    }

    @Override
    public void setValue(Integer value) {
        this.cache = value;
        if (this.setter != null) {
            this.setter.accept(this.cache);
        }
    }

    @Override
    public boolean needsSync(boolean isFirstSync) {
        return this.getter != null && (isFirstSync || this.getter.getAsInt() != this.cache);
    }

    @Override
    public void updateAndWrite(PacketBuffer buffer) {
        this.cache = this.getter.getAsInt();
        buffer.func_150787_b(this.cache);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.cache = buffer.func_150792_a();
        if (this.setter != null) {
            this.setter.accept(this.cache);
        }
    }

    @Override
    public void updateFromClient(Integer value) {
        this.setter.accept(value);
        this.syncToServer(0, this::updateAndWrite);
    }

    @Override
    public Integer fromString(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public int getCacheAsInt() {
        return this.cache;
    }

    @Override
    public Integer fromInt(int val) {
        return val;
    }
}

