/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import com.cleanroommc.modularui.sync.MapKey;
import com.cleanroommc.modularui.utils.ClickData;
import com.cleanroommc.modularui.widgets.slot.ICustomSlot;
import com.cleanroommc.modularui.widgets.slot.SlotCustomSlot;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemSlotSH
extends SyncHandler {
    private final SlotCustomSlot customSlot;
    private final Slot slot;
    private Predicate<ItemStack> filter;
    private String slotGroup;
    private boolean phantom = false;
    private ItemStack lastStoredPhantomItem = ItemStack.field_190927_a;

    public static ItemSlotSH phantom(Slot slot) {
        return new ItemSlotSH(slot).phantom(true);
    }

    public static ItemSlotSH phantom(IItemHandlerModifiable itemHandler, int index) {
        return new ItemSlotSH(itemHandler, index).phantom(true);
    }

    public static ItemSlotSH phantom(final int slotLimit, final Predicate<ItemStack> filter) {
        ItemStackHandler itemStackHandler = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return slotLimit;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return filter == null || filter.test(stack);
            }
        };
        return ItemSlotSH.phantom((IItemHandlerModifiable)itemStackHandler, 0);
    }

    public static ItemSlotSH phantom(int slotLimit) {
        return ItemSlotSH.phantom(slotLimit, null);
    }

    public static ItemSlotSH phantom() {
        return ItemSlotSH.phantom(64, null);
    }

    public ItemSlotSH(Slot slot) {
        this.slot = slot;
        this.customSlot = slot instanceof SlotCustomSlot ? (SlotCustomSlot)slot : null;
    }

    public ItemSlotSH(IItemHandlerModifiable itemHandler, int index) {
        this((Slot)new SlotCustomSlot((IItemHandler)itemHandler, index, 0, 0));
    }

    public ItemSlotSH(IInventory itemHandler, int index) {
        this(new Slot(itemHandler, index, 0, 0));
    }

    @Override
    public void init(MapKey key, GuiSyncHandler syncHandler) {
        super.init(key, syncHandler);
        syncHandler.getContainer().registerSlot(this);
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 2) {
            this.phantomClick(ClickData.readPacket(buf));
        } else if (id == 3) {
            this.phantomScroll(ClickData.readPacket(buf));
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(ClickData clickData) {
        ItemStack cursorStack = this.getSyncHandler().getCursorItem();
        ItemStack slotStack = this.getSlot().func_75211_c();
        if (slotStack.func_190926_b()) {
            ItemStack stackToPut;
            if (cursorStack.func_190926_b()) {
                if (clickData.mouseButton != 1 || this.lastStoredPhantomItem.func_190926_b()) return;
                stackToPut = this.lastStoredPhantomItem.func_77946_l();
            } else {
                stackToPut = cursorStack.func_77946_l();
            }
            if (clickData.mouseButton == 1) {
                stackToPut.func_190920_e(1);
            }
            this.slot.func_75215_d(stackToPut);
            this.lastStoredPhantomItem = stackToPut.func_77946_l();
            return;
        } else if (clickData.mouseButton == 0) {
            if (clickData.shift) {
                this.slot.func_75215_d(ItemStack.field_190927_a);
                return;
            } else {
                this.incrementStackCount(-1);
            }
            return;
        } else {
            if (clickData.mouseButton != 1) return;
            this.incrementStackCount(1);
        }
    }

    protected void phantomScroll(ClickData clickData) {
        ItemStack currentItem = this.slot.func_75211_c();
        int amount = clickData.mouseButton;
        if (clickData.shift) {
            amount *= 4;
        }
        if (clickData.ctrl) {
            amount *= 16;
        }
        if (clickData.alt) {
            amount *= 64;
        }
        if (amount > 0 && currentItem.func_190926_b() && !this.lastStoredPhantomItem.func_190926_b()) {
            ItemStack stackToPut = this.lastStoredPhantomItem.func_77946_l();
            stackToPut.func_190920_e(amount);
            this.slot.func_75215_d(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.getSlot().func_75211_c();
        if (stack.func_190926_b()) {
            return;
        }
        int oldAmount = stack.func_190916_E();
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getSlot().func_75219_a();
            if (!(this.customSlot != null && this.customSlot.isIgnoreMaxStackSize() || stack.func_77976_d() >= maxSize)) {
                maxSize = stack.func_77976_d();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack.func_190920_e(amount);
            this.getSlot().func_75218_e();
        }
    }

    public void setEnabled(boolean enabled, boolean sync) {
        if (this.slot instanceof ICustomSlot) {
            ((ICustomSlot)this.slot).setEnabled(enabled);
            if (sync) {
                this.sync(4, buffer -> buffer.writeBoolean(enabled));
            }
        }
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.getSlot().func_75214_a(itemStack) && (this.filter == null || this.filter.test(itemStack));
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public String getSlotGroup() {
        return this.slotGroup;
    }

    public ItemSlotSH filter(Predicate<ItemStack> filter) {
        this.filter = filter;
        return this;
    }

    public ItemSlotSH phantom(boolean phantom) {
        this.phantom = phantom;
        return this;
    }

    public ItemSlotSH ignoreMaxStackSize(boolean ignore) {
        if (this.customSlot == null) {
            throw new IllegalStateException("Slot must be a SlotCustomSlot");
        }
        this.customSlot.setIgnoreMaxStackSize(ignore);
        return this;
    }

    public ItemSlotSH slotGroup(String name) {
        this.slotGroup = name;
        return this;
    }
}

