/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.api.sync.IStringSyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import com.cleanroommc.modularui.network.NetworkUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class StringSyncHandler
extends ValueSyncHandler<String>
implements IStringSyncHandler<String> {
    private final Supplier<String> getter;
    private final Consumer<String> setter;
    private String cache;

    public StringSyncHandler(Supplier<String> getter, Consumer<String> setter) {
        this.getter = getter;
        this.setter = setter;
        this.cache = getter.get();
    }

    @Override
    public String getCachedValue() {
        return this.cache;
    }

    @Override
    public void setValue(String value) {
        this.cache = value;
    }

    @Override
    public boolean needsSync(boolean isFirstSync) {
        return isFirstSync || !this.getter.get().equals(this.cache);
    }

    @Override
    public void updateAndWrite(PacketBuffer buffer) {
        this.setValue(this.getter.get());
        NetworkUtils.writeStringSafe(buffer, this.getCachedValue());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue(buffer.func_150789_c(Short.MAX_VALUE));
        this.setter.accept(this.getCachedValue());
    }

    @Override
    public void updateFromClient(String value) {
        this.setter.accept(value);
        this.syncToServer(0, this::updateAndWrite);
    }

    @Override
    public String fromString(String value) {
        return value;
    }
}

