/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.sync;

import com.cleanroommc.modularui.sync.BooleanSyncHandler;
import com.cleanroommc.modularui.sync.DoubleSyncHandler;
import com.cleanroommc.modularui.sync.EnumSyncHandler;
import com.cleanroommc.modularui.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.sync.IntSyncHandler;
import com.cleanroommc.modularui.sync.ItemSlotSH;
import com.cleanroommc.modularui.sync.LongSyncHandler;
import com.cleanroommc.modularui.sync.StringSyncHandler;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SyncHandlers {
    private SyncHandlers() {
    }

    public static IntSyncHandler intNumber(IntSupplier getter, IntConsumer setter) {
        return new IntSyncHandler(getter, setter);
    }

    public static LongSyncHandler longNumber(LongSupplier getter, LongConsumer setter) {
        return new LongSyncHandler(getter, setter);
    }

    public static BooleanSyncHandler bool(BooleanSupplier getter, Consumer<Boolean> setter) {
        return new BooleanSyncHandler(getter, setter);
    }

    public static DoubleSyncHandler doubleNumber(DoubleSupplier getter, DoubleConsumer setter) {
        return new DoubleSyncHandler(getter, setter);
    }

    public static StringSyncHandler string(Supplier<String> getter, Consumer<String> setter) {
        return new StringSyncHandler(getter, setter);
    }

    public static ItemSlotSH itemSlot(Slot slot) {
        return new ItemSlotSH(slot);
    }

    public static ItemSlotSH itemSlot(IItemHandlerModifiable inventory, int index) {
        return new ItemSlotSH(inventory, index);
    }

    public static ItemSlotSH itemSlot(IInventory inventory, int index) {
        return new ItemSlotSH(inventory, index);
    }

    public static ItemSlotSH phantomItemSlot(IItemHandlerModifiable inventory, int index) {
        return ItemSlotSH.phantom(inventory, index);
    }

    public static FluidSlotSyncHandler fluidSlot(IFluidTank fluidTank) {
        return new FluidSlotSyncHandler(fluidTank);
    }

    public static <T extends Enum<T>> EnumSyncHandler<T> enumValue(Class<T> clazz, Supplier<T> getter, Consumer<T> setter) {
        return new EnumSyncHandler<T>(clazz, getter, setter);
    }
}

