/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.theme.AbstractDefaultTheme;
import com.cleanroommc.modularui.theme.Theme;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTextFieldTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import com.cleanroommc.modularui.utils.AssetHelper;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@ApiStatus.Internal
public class ThemeManager
implements ISelectiveResourceReloadListener {
    private static final String DEFAULT = "DEFAULT";
    private static final Map<String, ITheme> THEMES = new Object2ObjectOpenHashMap();
    protected static final Map<String, WidgetTheme> defaultWidgetThemes = new Object2ObjectOpenHashMap();
    private static final Map<String, WidgetThemeParser> widgetThemeFunctions = new Object2ObjectOpenHashMap();
    protected static final WidgetTheme defaultdefaultWidgetTheme = new WidgetTheme(null, null, Color.WHITE.normal, -12566464, false);
    private static final Map<String, ITheme> jsonScreenThemes = new Object2ObjectOpenHashMap();
    private static final Map<String, ITheme> screenThemes = new Object2ObjectOpenHashMap();

    public static void registerWidgetTheme(String id, WidgetTheme defaultTheme, WidgetThemeParser function) {
        if (widgetThemeFunctions.containsKey(id)) {
            throw new IllegalStateException();
        }
        widgetThemeFunctions.put(id, function);
        defaultWidgetThemes.put(id, defaultTheme);
    }

    public static void registerDefaultTheme(String screenId, ITheme theme) {
        Objects.requireNonNull(screenId);
        Objects.requireNonNull(theme);
        screenThemes.put(screenId, theme);
    }

    private static void registerTheme(ITheme theme) {
        if (THEMES.containsKey(theme.getId())) {
            throw new IllegalArgumentException("Theme with id " + theme.getId() + " already exists!");
        }
        THEMES.put(theme.getId(), theme);
    }

    public static ITheme get(String id) {
        return THEMES.getOrDefault(id, Theme.DEFAULT_DEFAULT);
    }

    public static ITheme getThemeFor(String mod, String name) {
        ITheme theme = jsonScreenThemes.get(mod + ":" + name);
        if (theme != null) {
            return theme;
        }
        theme = jsonScreenThemes.get(mod);
        if (theme != null) {
            return theme;
        }
        theme = screenThemes.get(mod + ":" + name);
        if (theme != null) {
            return theme;
        }
        return jsonScreenThemes.getOrDefault(mod, ThemeManager.get(ModularUIConfig.useDarkThemeByDefault ? "vanilla_dark" : "vanilla"));
    }

    public static void reload() {
        THEMES.clear();
        jsonScreenThemes.clear();
        ThemeManager.registerTheme(Theme.DEFAULT_DEFAULT);
        ThemeManager.loadThemes();
        ThemeManager.loadScreenThemes();
    }

    public static void loadThemes() {
        Object theme;
        Map<String, String> themesPaths = ThemeManager.findRegisteredThemes();
        Object2ObjectOpenHashMap themeMap = new Object2ObjectOpenHashMap();
        SortedJsonThemeList themeList = new SortedJsonThemeList((Map)themeMap);
        for (Map.Entry<String, String> entry : themesPaths.entrySet()) {
            theme = ThemeManager.loadThemeJson(entry.getKey(), entry.getValue());
            if (theme == null) continue;
            themeMap.put(entry.getKey(), theme);
        }
        if (themeMap.isEmpty()) {
            return;
        }
        ThemeManager.validateAncestorTree((Map<String, ThemeJson>)themeMap);
        if (themeMap.isEmpty()) {
            return;
        }
        themeList.addAll(themeMap.values());
        for (ThemeJson themeJson : themeList) {
            theme = themeJson.deserialize();
            ThemeManager.registerTheme((ITheme)theme);
        }
    }

    private static void validateAncestorTree(Map<String, ThemeJson> themeMap) {
        ObjectOpenHashSet invalidThemes = new ObjectOpenHashSet();
        block0: for (ThemeJson theme : themeMap.values()) {
            if (invalidThemes.contains(theme)) continue;
            ObjectOpenHashSet parents = new ObjectOpenHashSet();
            parents.add(theme);
            ThemeJson parent = theme;
            while (!DEFAULT.equals(parent.parent)) {
                if ((parent = themeMap.get(parent.parent)) == null) {
                    ModularUI.LOGGER.error("Can't find parent '{}' for theme '{}'! All children for '{}' are therefore invalid!", (Object)theme.parent, (Object)theme.id, (Object)theme.id);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (parents.contains(parent)) {
                    ModularUI.LOGGER.error("Ancestor tree for themes can't be circular! All of the following make a circle or are children of the circle: {}", (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (invalidThemes.contains(parent)) {
                    ModularUI.LOGGER.error("Parent '{}' was found to be invalid before. All following are children of it and are therefore invalid too: {}", (Object)theme.parent, (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                parents.add(parent);
            }
        }
        for (ThemeJson theme : invalidThemes) {
            themeMap.remove(theme.id);
        }
    }

    private static ThemeJson loadThemeJson(String id, String path) {
        ResourceLocation rl;
        if (path.contains(":")) {
            String[] parts = path.split(":", 2);
            rl = new ResourceLocation(parts[0], "themes/" + parts[1] + ".json");
        } else {
            rl = new ResourceLocation("themes/" + path + ".json");
        }
        IResource resource = AssetHelper.findAsset(rl);
        if (resource == null) {
            return null;
        }
        JsonElement element = JsonHelper.parse(resource.func_110527_b());
        try {
            resource.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (element.isJsonObject()) {
            return new ThemeJson(id, element.getAsJsonObject());
        }
        ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a JsonObject!"));
        return null;
    }

    private static Map<String, String> findRegisteredThemes() {
        Object2ObjectOpenHashMap themes = new Object2ObjectOpenHashMap();
        for (IResource resource : AssetHelper.findAssets("modularui", "themes.json")) {
            try {
                JsonElement element = JsonHelper.parse(resource.func_110527_b());
                if (!element.isJsonObject()) {
                    resource.close();
                    continue;
                }
                JsonObject definitions = element.getAsJsonObject();
                for (Map.Entry entry : definitions.entrySet()) {
                    if (((String)entry.getKey()).equals("screens")) continue;
                    if (((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonArray() || ((JsonElement)entry.getValue()).isJsonNull()) {
                        ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a string!"));
                        continue;
                    }
                    themes.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                resource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return themes;
    }

    private static void loadScreenThemes() {
        for (IResource resource : AssetHelper.findAssets("modularui", "themes.json")) {
            try {
                JsonElement element = JsonHelper.parse(resource.func_110527_b());
                if (!element.isJsonObject()) {
                    resource.close();
                    continue;
                }
                JsonObject definitions = element.getAsJsonObject();
                if (definitions.has("screens") && (element = definitions.get("screens")).isJsonObject()) {
                    for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                        ITheme theme;
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (theme = THEMES.get(((JsonElement)entry.getValue()).getAsString())) == null) continue;
                        jsonScreenThemes.put((String)entry.getKey(), theme);
                    }
                }
                resource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onResourceManagerReload(@NotNull IResourceManager resourceManager, @NotNull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            ModularUI.LOGGER.info("Reloading Themes...");
            ThemeManager.reload();
        }
    }

    static {
        ThemeManager.registerWidgetTheme("panel", new WidgetTheme(GuiTextures.BACKGROUND, null, Color.WHITE.normal, -12566464, false), WidgetTheme::new);
        ThemeManager.registerWidgetTheme("button", new WidgetTheme(GuiTextures.BUTTON, null, Color.WHITE.normal, Color.WHITE.normal, true), WidgetTheme::new);
        ThemeManager.registerWidgetTheme("itemSlot", new WidgetSlotTheme(GuiTextures.SLOT, Color.withAlpha(Color.WHITE.normal, 128)), WidgetSlotTheme::new);
        ThemeManager.registerWidgetTheme("fluidSlot", new WidgetSlotTheme(GuiTextures.SLOT_DARK, Color.withAlpha(Color.WHITE.normal, 128)), WidgetSlotTheme::new);
        ThemeManager.registerWidgetTheme("textField", new WidgetTextFieldTheme(-13667672), WidgetTextFieldTheme::new);
    }

    private static class SortedJsonThemeList
    extends ArrayList<ThemeJson> {
        private final Map<String, ThemeJson> themeMap;

        private SortedJsonThemeList(Map<String, ThemeJson> themeMap) {
            this.themeMap = themeMap;
        }

        @Override
        public boolean addAll(Collection<? extends ThemeJson> c) {
            for (ThemeJson themeJson : c) {
                this.add(themeJson);
            }
            return !c.isEmpty();
        }

        @Override
        public boolean add(ThemeJson theme) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.isAncestor((ThemeJson)this.get(i), theme)) continue;
                this.add(i, theme);
                return true;
            }
            this.add(this.size(), theme);
            return true;
        }

        private boolean isAncestor(ThemeJson potentialAncestor, ThemeJson theme) {
            do {
                if (!ThemeManager.DEFAULT.equals(theme.parent)) continue;
                return false;
            } while (potentialAncestor != (theme = this.themeMap.get(theme.parent)));
            return true;
        }
    }

    private static class ThemeJson {
        private final String id;
        private final String parent;
        private final JsonObject json;

        private ThemeJson(String id, JsonObject json) {
            this.id = id;
            this.parent = JsonHelper.getString(json, ThemeManager.DEFAULT, "parent");
            this.json = json;
        }

        private Theme deserialize() {
            ITheme parent = (ITheme)THEMES.get(this.parent);
            if (parent == null) {
                throw new IllegalStateException(String.format("Ancestor tree was validated, but parent '%s' was still null during parsing!", this.parent));
            }
            Object2ObjectOpenHashMap widgetThemes = new Object2ObjectOpenHashMap();
            WidgetTheme parentWidgetTheme = parent.getFallback();
            WidgetTheme fallback = new WidgetTheme(parentWidgetTheme, this.json, this.json);
            widgetThemes.put("default", fallback);
            JsonObject emptyJson = new JsonObject();
            for (Map.Entry entry : widgetThemeFunctions.entrySet()) {
                JsonElement element;
                JsonObject json = this.json.has((String)entry.getKey()) ? ((element = this.json.get((String)entry.getKey())).isJsonObject() ? element.getAsJsonObject() : emptyJson) : emptyJson;
                parentWidgetTheme = parent.getWidgetTheme((String)entry.getKey());
                widgetThemes.put(entry.getKey(), ((WidgetThemeParser)entry.getValue()).parse(parentWidgetTheme, this.json, json));
            }
            return new Theme(this.id, parent, (Map<String, WidgetTheme>)widgetThemes);
        }
    }

    public static class DefaultTheme
    extends AbstractDefaultTheme {
        @Override
        public String getId() {
            return ThemeManager.DEFAULT;
        }

        @Override
        public WidgetTheme getFallback() {
            return defaultdefaultWidgetTheme;
        }

        @Override
        public WidgetTheme getWidgetTheme(String id) {
            return defaultWidgetThemes.get(id);
        }
    }
}

